;**************************************************
;
;       Function DowS ( MM, DD, CCYY : Integer) :
;                        DowString;
;
;               DowString is Type string[9];
;               Returns day of week for any
;               valid Gregorian date.
;
;**************************************************
Dow00	Proc
	push	bp
	mov	bp,sp
	push	ds
	call	nothing
	jmp	Next1
;
table	db	0,3,2,5,0,3,5,1,4,6,2,4
;
Next1:
	add	bx,3
	mov	di,bx
	mov	bx,[bp+8]	; MM
	mov	cx,[bp+6]	; DD
	mov	dx,[bp+4]	; CCYY
;
	cmp	bx,3		; MM < 3?
	jae	Dow1
	dec	dx		; CCYY-1
Dow1:	add	di,bx
	dec	di
	add	cl,cs:[di] ; DD=DD +
                         ;    Table(MM)
	mov	ax,dx
	mov	bx,100
	xor	bh,bh
	div	bl		; CC=CCYY \ 100
;                                 CC in al
;                                 YY in ah
	push	cx		; save
	push	ax		; save DD
	mov	cl,2
	ror	ah,cl
	mov	cl,6
	shr	ah,cl		; YY MOD 4
	mov	bl,ah		; Save in bl
;
        pop     ax
        mov     cl,2
        ror     al,cl
        mov     cl,6
        shr     al,cl           ; CC MOD 4
;
	mov	cl,2
	mov	dl,ah
	shr	dl,cl		; YY \ 4
;
;    bl = Number Reg years since last leap year
;    al = Number Centuries since last 400-yr cycle
;    ah = Year (e.g., for 1985, ah = 85)
;    dl = Leap years since start of century
;
	pop	cx
	add	al,dl		; Leap + Cent
	mov	bh,5
	mul	bh
	xor	bh,bh
	add	ax,bx
	add	ax,cx
	mov	dx,7
	div	dl
	mov	al,ah
	xor	ah,ah
	call	nothing
	jmp	next2
days	db	'Sunday   ',
	db	'Monday   ',
	db	'Tuesday  ',
	db	'Wednesday',
	db	'Thursday ',
	db	'Friday   ',
	db	'Saturday '
;
nothing proc
	mov	bx,sp
	mov	bx,ss:[bx]
	ret
nothing endp
;
next2	add	bx,3
	mov	si,bx
	mov	cx,9
	mul	cl
	add	si,al
	push	cs
	pop	ds
	push	ss
	pop	es
	mov	[bp+10],cl
	lea	di,[bp+11]
	cld
rep	movsb
;
	pop	ds
	mov	sp,bp
	pop	bp
	ret	6
Dow00	endp
