{ ------------------------------------------------
  COPYBLK copies one part of the screen to another
  ------------------------------------------------ }
  Procedure COPYBLK ( X1,Y1,X2,Y2,X3,Y3 : Integer);

{           Copies block defined by upper left and lower right
            coordinates (X1,Y1),(X2,Y2) to a block beginning
            at upper left coordinates (X3,Y3).                }

begin
   Inline ( $1E/                 { push  ds             Save DS!            }
            $BB/$49/$04/         { mov   bx,449h        video byte offset   }
            $31/$C0/             { xor   ax,ax          ax = 0              }
            $8E/$D8/             { mov   ds,ax          video byte seg      }
            $8A/$07/             { mov   al,[bx]        get byte            }
            $3C/$07/             { cmp   al,7           mono?               }
            $75/$06/             { jne   graphx         no                  }
            $BA/$00/$B0/         { mov   dx,0B000h      regen for mono      }
            $EB/$0C/$90/         { jmp   start          go to parm analysis }
            $BA/$DA/$03/
            $EC/
            $24/$08/
            $74/$FB/             { jz    vtrace }
                         { graphx:                                          }
            $BA/$00/$B8/         { mov   dx,0B800h      regen for graphics  }
            $52/         { start:  push  dx                                 }
            $8B/$5E/$0C/         { mov   bx,[bp+12]     Y1                  }
            $4B/                 { dec   bx             Y1 - 1              }
            $8B/$D3/             { mov   dx,bx          Save in dx          }
            $B1/$07/             { mov   cl,7           prepare to shl      }
            $D3/$E2/             { shl   dx,cl          (Y1-1) * 128        }
            $B1/$05/             { mov   cl,5           another shift       }
            $D3/$E3/             { shl   bx,cl          (Y1-1) * 32         }
            $01/$D3/             { add   bx,dx          (Y1-1) * 160 = row  }
            $8B/$46/$0E/         { mov   ax,[bp+14]     X1                  }
            $48/                 { dec   ax             X1 - 1              }
            $D1/$E0/             { shl   ax,1           2 * (X1-1) = col    }
            $01/$C3/             { add   bx,ax          bx = upper left     }
            $8B/$F3/             { mov   si,bx          save for move later }
            $1F/                 { pop   ds             DS:SI start addr    }
            $1E/                 { push  ds             save for later move }
            $8B/$5E/$04/         { mov   bx,[bp+04]     Y3                  }
            $4B/                 { dec   bx             Y3 - 1              }
            $8B/$D3/             { mov   dx,bx          save Y3 - 1         }
            $B1/$07/             { mov   cl,7           shl coming          }
            $D3/$E2/             { shl   dx,cl          (Y3-1) * 128        }
            $B1/$05/             { mov   cl,5           setup shl           }
            $D3/$E3/             { shl   bx,cl          (Y3-1) * 32         }
            $01/$D3/             { add   bx,dx          (Y3-1) * 160 = row  }
            $8B/$46/$06/         { mov   ax,[bp+06]     X3                  }
            $48/                 { dec   ax             X3 - 1              }
            $D1/$E0/             { shl   ax,1           2 * (X3-1) = col    }
            $01/$C3/             { add   bx,ax          upper left of dest  }
            $8B/$FB/             { mov   di,bx          setup for movsw     }
            $07/                 { pop   es             ES:DI established   }
            $8B/$46/$0C/         { mov   ax,[bp+12]     Y1                  }
            $8B/$56/$08/         { mov   dx,[bp+08]     Y2                  }
            $29/$C2/             { sub   dx,ax                              }
            $42/                 { inc   dx             dx = num lines/move }
            $8B/$46/$0E/         { mov   ax,[bp+14]     X1                  }
            $8B/$4E/$0A/         { mov   cx,[bp+10]     X2                  }
            $29/$C1/             { sub   cx,ax                              }
            $41/                 { inc   cx             cx = num bytes/line }
                         { MOVER:                                           }
            $51/                 { push  cx             keep copy on hand   }
            $FC/                 { cld                  forward move        }
            $F3/$A5/     { rep     movsw                copy block          }
            $59/                 { pop   cx             restore count       }
            $4A/                 { dec   dx             1 less line to copy }
            $74/$0F/             { jz    done           if zero, return     }
            $8B/$D9/             { mov   bx,cx          find beginning . . .}
            $D1/$E3/             { shl   bx,1           of next . . .       }
            $B8/$A0/$00/         { mov   ax,160         line to move.       }
            $29/$D8/             { sub   ax,bx          leave offset in ax  }
            $01/$C6/             { add   si,ax          make SI point to it }
            $01/$C7/             { add   di,ax          ditto for DI        }
            $EB/$E9/             { jmp   mover          move next line      }
                         { DONE:                                            }
            $1F);                { pop   ds             restore DS          }
end;