;************************************************
;
;       Procedure COPYBLK ( X1 : ColumnType;
;                           Y1 : RowType;
;                           X2 : ColumnType;
;                           Y2 : RowType;
;                           X3 : ColumnType;
;                           Y3 : RowType );
;
;       Copies block from screen at X1,Y1,X2,Y2
;                                to X3,Y3
;************************************************
CopyBlk proc    near
        push    bp
	mov	bp,sp
	push	ds
;
;***  Determine monitor type
;
	mov	bx,449h
	xor	ax,ax
	mov	ds,ax
	mov	al,[bx]
	cmp	al,7		; Monochrome?
	jne	graphx
	mov	dx,0B000h
	jmp	c001
graphx:
	mov	dx,03DAh	; for IBM CGA,
VR:	in	al,dx		; we must do this
	and	al,1000b	; so we won't see
	jz	vr		; snow
	mov	dx,0B800h
c001:	push	dx
;
;***  Compute X,Y addresses
;
	mov	bx,[bp+12]	;  Y1
        dec     bx              ;  (Y1-1)
	mov	dx,bx		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y1-1) * 128
	mov	cl,5
	shl	bx,cl		;  (Y1-1) *  32
	add	bx,dx		;  (Y1-1) * 160
	mov	ax,[bp+14]	;  X1
	dec	ax		;  (X1-1)
	shl	ax,1		;  2 * (X1-1)
	add	bx,ax		;  X1,Y1 offset in BX
	mov	si,bx		;  Move to SI
	pop	ds		;  DS:SI --> X1,Y1
	push	ds
;
	mov	bx,[bp+04]	;  Y3
        dec     bx              ;  (Y3-1)
	mov	dx,bx		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y3-1) * 128
	mov	cl,5
	shl	bx,cl		;  (Y3-1) *  32
	add	bx,dx		;  (Y3-1) * 160
	mov	ax,[bp+06]	;  X3
	dec	ax		;  (X3-1)
	shl	ax,1		;  2 * (X3-1)
	add	bx,ax		;  X3,Y3 in BX
	mov	di,bx		;  move to DI
	pop	es		;  ES:DI --> X3,Y3
;
;
;*** Compute number of lines to move
;
	mov	ax,[bp+12]	; Y1 into AX
	mov	dx,[bp+08]	; Y2 into DX
        sub     dx,ax           ; DX = DX - AX
	inc	dx		; DX = Num of lines
;
;
;*** Compute length of each move
;
	mov	ax,[bp+14]	;  X1 into AX
	mov	cx,[bp+10]	;  X2 into CX
	sub	cx,ax		;  CX = X1 - X2
	inc	cx		;  CX = line length
;
;*** Move block
;
MOVER:	push	cx		; save line length
        cld                     ; forward move
rep	movsw			; move a line
	pop	cx		; restore line length
	dec	dx		; decrement Num lines
	jz	DONE		; Done if zero
	mov	bx,cx		; otherwise continue
	shl	bx,1
	mov	ax,160
	sub	ax,bx
	add	si,ax		; adjust pointers
	add	di,ax
	jmp	MOVER		; etc.
;
DONE:   pop     ds
        mov     sp,bp
        pop     bp
	ret	12		; clear parameters
CopyBlk endp
