;*****************************************************
;
;       Procedure CblkHeap ( Page : HeapBuf;
;                              X1 : ColumnType;
;                              Y1 : RowType;
;                              X2 : ColumnType;
;                              Y2 : RowType;
;                              X3 : ColumnType;
;                              Y3 : RowType );
;
;              offset 18,16,14,12,10,08,06,04  from BP
;
;       Copies block on page of heap from X1,Y1,X2,Y2
;                                    to X3,Y3
;*****************************************************
CblkHeap proc    near
        push    bp
	mov	bp,sp
	push	ds
;
;*** Get address of page on heap
;
	mov	bx,[bp+18]
	mov	ds,bx
	mov	es,bx
	mov	di,[bp+16]
	mov	si,di
;
;*** Compute Source, Destination addresses for move
;
	mov	bx,[bp+12]	;  Y1
        dec     bx              ;  (Y1-1)
	mov	dx,bx		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y1-1) * 128
	mov	cl,5
	shl	bx,cl		;  (Y1-1) *  32
	add	bx,dx		;  (Y1-1) * 160
	mov	ax,[bp+14]	;  X1 into AX
	dec	ax		;  (X1-1)
	shl	ax,1		;  2 * (X1-1)
	add	bx,ax
	add	si,bx
;
	mov	bx,[bp+04]	;  Y3 into BX
        dec     bx              ;  (Y3-1)
	mov	dx,bx		;  Save in DX
	mov	cl,7
	shl	dx,cl		;  (Y3-1) * 128
	mov	cl,5
	shl	bx,cl		;  (Y3-1) *  32
	add	bx,dx		;  (Y3-1) * 160
	mov	ax,[bp+06]	;  X3 into AX
	dec	ax		;  (X3-1)
	shl	ax,1		;  2 * (X3-1)
	add	bx,ax
	add	di,bx
;
;
;*** Compute number of lines to move
;
	mov	ax,[bp+12]	; value of Y1 into AX
	mov	dx,[bp+08]	; value of Y2 into DX
        sub     dx,ax           ; DX = DX - AX
	inc	dx		; DX = Number of lines
;
;
;*** Compute length of each move
;
	mov	ax,[bp+14]	;  X1 into AX
	mov	cx,[bp+10]	;  X2 into CX
	sub	cx,ax		;  CX = X1 - X2
	inc	cx
;
;*** Move block
;
	mov	bx,cx
	shl	bx,1
	mov	ax,160
	sub	ax,bx
MOVER:	push	cx
        cld
rep	movsw
	pop	cx
	dec	dx
	jz	DONE
	add	si,ax
	add	di,ax
	jmp	MOVER
;
DONE:   pop     ds
        mov     sp,bp
        pop     bp
	ret	16
CblkHeap endp
