{ --------------------------------
  BOXHEAP builds a box on the heap
  at Page [n]
  -------------------------------- }
Procedure BoxHeap ( Page  :  HeapBuf;
                    Start_Col, Start_Row,
                    End_Col,   End_Row,   Style   : Integer;
                    Attribute  : Byte);

Var
   Ver_Adj, Hor_Adj, Num_Col, Num_Row : Integer;

Const
                                  { DOWN  LL  OVER  LR   UR   UL }
   s : array[1..4,1..6] of char = ((#179,#192,#196,#217,#191,#218),
                                   (#186,#200,#205,#188,#187,#201),
                                   (#186,#211,#196,#189,#183,#214),
                                   (#179,#212,#205,#190,#184,#213));

begin
   if (style < 1) or (style > 4) then
      style := 1;
   Num_Col := End_Col - Start_Col + 1;
   Num_Row := End_Row - Start_Row + 1;
   if Num_Col <= 2 then
      Num_Col := 3;
   if Num_Row <= 2 then
      Num_Row := 3;
   Ver_Adj := Num_Row - 2;
   Hor_Adj := Num_Col - 2;

   PutHeap ( Page, V, s[style,6],
                   Start_Col, Start_Row, Attribute);         { UL Corner  }

   PutHeap ( Page, V, COPIES( s[style,1], Ver_Adj),
                   Start_Col,  Start_Row + 1, Attribute);    { Left Side  }

   PutHeap ( Page, V, s[style,2],
                   Start_Col, End_Row, Attribute);           { LL Corner  }

   PutHeap ( Page, H, COPIES( s[style,3], Hor_Adj),
                   Start_Col + 1, End_Row, Attribute);       { Bottom     }

   PutHeap ( Page, V, s[style,4],
                   End_Col, End_Row, Attribute);             { LR Corner  }

   PutHeap ( Page, V, COPIES( s[style,1],Ver_Adj),
                   End_Col, Start_Row + 1, Attribute);       { Right Side }

   PutHeap ( Page, V, s[style,5],
                   End_Col, Start_Row, Attribute);           { UR Corner  }

   PutHeap ( Page, H, COPIES( s[style,3],Hor_Adj),
                   Start_Col + 1, Start_Row, Attribute);     { Top        }

end { BoxHeap };