Const
   H  = 'H';                  { Code for horizontal PutStr & GetStr }
   V  = 'V';                  { "    "   vertical   "      " "      }
   StartElapsed : Boolean = FALSE;
                              { Initial value for Timer function    }
   Npage = 4;                 { Number of heap pages                }

Var
   J                 : Integer;
   Att1, Att2        : Byte;

   MidPoint, H_Off   : Integer;

   StartCol, StartRow,
   NumCols,  NumRows,
   Xinc              : Integer;

{ ---------------------------------------
  BODECL declarations below, with PAGE[5]
  --------------------------------------- }

Type
   AnyString   =  string[255];
   HeapBuf     =  ^AnyBuf;
   AnyBuf      =  record
                     Screen : array[1..4000] of byte;
                  end;
   ColumnType  =  0..80;
   RowType     =  0..25;
   result      =  Record
                     AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : Integer;
                  end;

Var

   TimeElapsed,               { Used by Timer . . . }
   SaveElapsed,               { "    "  "           }
   PageSegment,               { Segment address of page }
   PageOffSet,                { Offset address of page }
   Ecode,                     { "    "  Exec for error return }
   I                          { the ubiquitous index variable  }
                     : Integer;
   SaveX                      { handy for saving WhereX result }
                     : ColumnType;
   SaveY                      { "     "   "      WhereY "      }
                     : RowType;
   Xheap             : ColumnType;
   Yheap             : RowType;

   HeapTop                    { Current top of heap }
                     : ^Integer;

   Ch                         { as in read(Kbd,ch) after KeyPressed }
                     : Char;

   Page                       { screens for SaveScreen, RestoreScreen,
                                and MoveBg }
                     : array[1..Npage] of HeapBuf;

   VideoStatus       : byte   absolute $0000:$0449;
   MonoBuffer        : AnyBuf absolute $B000:0000;
   GraphicsBuffer    : AnyBuf absolute $B800:0000;
   Regs              : Result;

   S,                         { general string array }
   FileDesc,                  { File name and extension for EXEC }
   ComLine                    { Command Line setting for EXEC    }
                     : AnyString;

const
   logo : array[1..6] of AnyString =

          ( '       ',
            '                             ',
            '                 ',
            '                            ',
            '             ',
            '                                        ');

   {$IBoosters}


{ --------------------------------------
  SELECT simulates selection from a menu
  -------------------------------------- }
Procedure Select;

var
   Num : Integer;

begin

   FstrHeap ( page[4], 'Qui', Xheap, Yheap );
   SetAtt  ( Xheap-1, Yheap, Xheap+24, Yheap, 112);
   SaveX := Xheap-1;
   SaveY := Yheap;
   wait(2);

          { Simulate UP arrow key press }
   for num := 1  to 3 do
   begin

      SetAtt ( SaveX, SaveY, SaveX+25, SaveY, 14);

      if SaveY = 10 then
         SaveY := 16
      else
         SaveY := SaveY - 2;

      SetAtt ( SaveX, SaveY, SaveX+25, SaveY, 112);

      Wait(2);
   end;

end { Select };

{ ------------------------
  MENU creates a demo menu
  ------------------------ }
Procedure Menu;
begin

   FillHeap ( page[4],  1, 1, 80, 25, ' ', 0 );
   BoxHeap  ( page[4], 20, 4, 60, 18, 2, 14);
   PutHeap  ( page[4], h,#181+' Atlanta Division '+#198, 30, 4, 14);
   HeapAt   ( page[4], 32, 4, 47, 4, 12 );

   PutHeap ( page[4], h, Center ( 'A BUDGET PREPARATION SYSTEM',39,' '),
           21, 6, 14 );
   PutHeap ( page[4], h, #199+Copies ( #196, 39 )+#182, 20, 8, 14);
   PutHeap ( page[4], h, Center ( 'Resource  Budget Updates',39,' '),21,10,14);
   PutHeap ( page[4], h, Center ( 'Equipment Budget Updates',39,' '),21,12,14);
   PutHeap ( page[4], h, Center ( 'Reports                 ',39,' '),21,14,14);
   PutHeap ( page[4], h, Center ( 'Quit                    ',39,' '),21,16,14);

   PutHeap ( page[4], h, Center ( #24+' Cursor Up   '+#25+' Cursor Down   '+
           #17+#196+'  Enter to select',80,' '),1,25,14);
   FstrHeap ( page[4], #17, Xheap, Yheap );
   PutHeap  ( page[4], h, #217, Xheap+2, Yheap, 14 );
   FstrHeap ( page[4], #24, Xheap, Yheap );
   HeapAt   ( page[4], Xheap-1, Yheap, Xheap+49, Yheap, 30 );
   BoxHeap ( page[4], 20, 20, 60, 22, 1, 14);
   PutHeap ( page[4], h, Center ('Please Make A Selection',38,' '),21,21,14);
   RestoreScreen ( page[4] );

   Select;

   If (SaveY = 10) or (SaveY = 12) then
   begin
      PutStr ( h, Center ('Enter Authorization Code',38,' '),21,21,112);
      wait(2);
   end;

end { Menu };

{ ORDERing Boosters }
Procedure Order;
var
   Buffer : integer;
const
   order : array[1..15] of AnyString =
          ('POSTSCRIPT',
           '    You are encouraged to use and share these ',
           '    utilities.  If you find that they are helpful,',
           '    a $25 contribution would be appreciated.',
           '    ',
           '    If you prefer, you may become a registered',
           '    user for $35 and receive a printed copy of the',
           '    users guide, update notices, and the latest ',
           '    version of Boosters.',
           '    ',
           '    Please send check or money order to:',
           'George F. Smith',
           '609 Candlewick Lane',
           'Lilburn, GA 30247',
           '(404) 923-6879');

begin

   FillHeap ( page[1], 1,1,80,25,' ',14 );
   BoxHeap  ( page[1], 9,3,71,23,1,14 );
   PutHeap  ( page[1],h, Center ( Order[1],60 ,' '), 10, 5, 14 );
   for i := 1 to 10 do
      PutHeap ( page[1],h, Order[i+1], 11, 6+i, 14 );
   for i := 1 to 4 do
      PutHeap ( page[1],h, Center ( Order[11+i],60 ,' '), 10, 17+i, 14 );

   {             Nice, terse code that unfortunately makes snow - sigh.
                 Other than that, it works beautifully.
   PageSegment := Seg( Page[1]^ );
   PageOffset  := Ofs( Page[1]^ );

   if VideoStatus = 7 then
      Buffer := $B000
   else
      Buffer := $B800;

   for i := 1 to 25 do
   begin
      move ( mem[ PageSegment:PageOffset ],
             mem[ Buffer:4000-(i*160) ], i*160 );
      delay(30);
   end;
   }

   ClrScr;
   for i := 1 to 25 do
   begin
      GetHeap ( Page[1], h, S, 1, i, 80 );
      PutStr  ( h, S, 1, 25, 14 );
      if i < 25 then
         writeln;
   end;
   SetAtt  ( 1,1,80,25,30 );
end { Order };

{ --------------------------
  OPENING procedure for demo
  -------------------------- }
Procedure Opening;
begin
     { Initialize }
     TimeElapsed := 0;

          { Build opening screen - Page[1] }
     FillHeap ( Page[1],  1, 1, 80, 25, ' ', 30);
     BoxHeap  ( Page[1], 13, 6, 67, 20, 2 ,14);
     HeapAt   ( Page[1], 14, 7, 66, 19, 0 );
     for i := 1 to 6 do
        PutHeap ( Page[1], h, Center(logo[i],53,' '), 14, 9+i, 14);
     RestoreScreen ( page[1] );
     wait(3);

          { Horizontal Wipe to clear screen }
     for i := 1 to 40 do
     begin
        RemBlk (1+(i-1)*2,1,2+(i-1)*2,25);
        SetAtt (1+(i-1)*2,1,2+(i-1)*2,25,14);
     end;

          { Display ID screen }
     SetAtt ( 23,  4, 56, 10, $1E);
     SetAtt ( 23, 11, 56, 17, $1E);
     PutStr ( H, Center ( 'Introducing', 34, #32), 23,  7, 30 );
     PutStr ( H, Center ( 'BOOSTERS', 34, #32), 23, 9, 30 );
     PutStr ( H, Center ( 'Assembly-Honed Helpers', 34, #32), 23, 12, 30 );
     PutStr ( H, Center ( 'For Turbo Pascal Programmers', 34, #32), 23,13,30 );
     BoxUL   ( 23,  4, 56, 17, 1, 30 );
     wait(4);

          { Build supplement box on heap }
     SaveScreen ( page[1] );
          { Move ID screen to make room for supplement box }
     MblkHeap ( page[1], 23,  4, 56, 17, 5,  4 );
          { Draw supplement box }
     BoxHeap  ( page[1], 43,  4, 76, 17, 2, 14 );
     PutHeap  ( page[1], H, Center ( 'String and video routines',32,#32),
              44,  8, 12 );
     PutHeap  ( page[1], H, Center ( '- plus -', 32, #32), 44, 10, 12 );
     PutHeap  ( page[1], H, Center ( 'Special-purpose programs', 32, #32),
              44, 12, 12 );
     RestoreScreen ( page[1] );
     wait(5);

     FillHeap ( Page[1],  1,  1, 80, 25, ' ', 14 );
     HeapAt   ( Page[1], 23,  4, 56, 17, 30);
     BoxHeap  ( Page[1], 23,  4, 56, 17, 1, 30);
     PutHeap  ( Page[1], H, Center ('BOOSTERS DEMO WILL', 32, #32),
              24,  6, 30);
     PutHeap  ( Page[1], H, Left   ('- Run by itself',28,#32),
              26,  8, 30);
     PutHeap  ( Page[1], H, Left   ('- Advance faster with', 28, #32),
              26, 10, 30);
     PutHeap  ( Page[1], H, Left   ('  repeated key presses',28,#32),
              26, 11, 30);
     PutHeap  ( Page[1], H, Left   ('- Halt and wait for another', 28, #32),
              26,13,30);
     PutHeap  ( Page[1], H, Left   ('  key press if you press HOME', 29, #32),
              26,14,30);
     PutHeap  ( Page[1], H, Center (#06+#32+#06+#32+#06, 32, #32), 24, 16,30);
     RestoreScreen ( page[1] );
     wait(7);
end { Opening } ;

{ -----------------------------
  OVERVIEW of Boosters routines
  ----------------------------- }
Procedure OverView;
begin

          { Build Boosters overview chart on heap }
          { First, clear out a page . . . . }
     FillHeap ( Page[1],  1, 1, 80, 25, ' ', 0);
          { Then draw the five boxes . . . }
     BoxHeap  ( Page[1], 30,  1, 50,  5, 3, 14 );
     BoxHeap  ( Page[1], 30,  8, 50, 12, 3, 14);
     BoxHeap  ( Page[1],  5, 15, 25, 17, 1, 14);
     BoxHeap  ( Page[1], 30, 15, 50, 17, 1, 14);
     BoxHeap  ( Page[1], 55, 15, 75, 17, 1, 14);

          { Draw vertical connectors . . . }
     PutHeap  ( Page[1], H, #194,      40,  5, 14);
     PutHeap  ( Page[1], V, #179+#179, 40,  6, 14);
     PutHeap  ( Page[1], V, #193,      40,  8, 14);
     PutHeap  ( Page[1], H, #194,      40, 12, 14);
     PutHeap  ( Page[1], V, #179+#179, 40, 13, 14);

          { Draw horizontal connecting lines . . . }
     PutHeap  ( Page[1], H, Copies (#196, 25), 40, 14, 14);
     PutHeap  ( Page[1], H, Copies (#196, 25), 15, 14, 14);

          { Draw more connectors . . . }
     PutHeap  ( Page[1], H, #197, 40, 14, 14);
     PutHeap  ( Page[1], H, #193, 40, 15, 14);
     PutHeap  ( Page[1], V, #218, 15, 14, 14);
     PutHeap  ( Page[1], V, #193, 15, 15, 14);
     PutHeap  ( Page[1], V, #191, 65, 14, 14);
     PutHeap  ( Page[1], V, #193, 65, 15, 14);

          { Write text into boxes . . . }
     PutHeap  ( Page[1], H, Center ('MS-DOS and ', 19, ' '), 31,  2, 14);
     PutHeap  ( Page[1], H, Center ('Turbo Pascal',19, ' '), 31,  3, 14);
     PutHeap  ( Page[1], H, Center ('Environment' ,19, ' '), 31,  4, 14);

     PutHeap  ( Page[1], H, Center (#$11+' BOOSTERS '#$10, 19, ' '), 31,10,14);
     PutHeap  ( Page[1], H, Center ('String Functions', 19, ' '),  6, 16, 14);
     PutHeap  ( Page[1], H, Center ('Special Routines', 19, ' '), 31, 16, 14);
     PutHeap  ( Page[1], H, Center ('Video Procedures', 19, ' '), 56, 16, 14);

          { Finally, display the overview chart, quickly and w/o snow }
     RestoreScreen ( page[1] );
     Wait(4);
end { OverView };

{ --------------------
  STRING function demo
  -------------------- }
Procedure StringDemo;
begin

          { Clear page for string function demo }
     FillHeap ( Page[2],  1,  1, 80, 25, ' ', 14 );

          { Draw boxes for text }
     BoxHeap  ( Page[2],  5,  8, 25, 10, 1, 14);
     BoxHeap  ( Page[2],  5, 10, 25, 19, 4, 14);
     PutHeap  ( Page[2], H, Center ('String Functions', 19, ' '),  6,  9, 14);

          { Draw connectors to make two boxes seem like one }
     PutHeap ( Page[2], V, #198,  5, 10, 14);
     PutHeap ( Page[2], V, #181, 25, 10, 14);

     s := 'Center  Copies  Left    OverStr Right   Strip   Upper   CopyStr ';
     for i := 1 to 8 do
        PutHeap ( Page[2], H, Copy( S, 1+(i-1)*8, 8), 12, 10 + i, 14);
     RestoreScreen ( Page[2] );
     Wait(2);

          { Draw large box in which to write poem }
     BoxUl  ( 30,  8, 76, 19,  3, 14);

     Att1 := $1E;
     Boxul  ( 20, 22, 59, 24,  2, Att1 );

     PutStr ( H, Center ('Center and pad a string in a field',38,' '),
                 21,23,Att1);

     SetAtt (  6, 11, 24, 11, 112);
     PutStr ( H, Center ('Growing Pains', 44, ' '), 31, 11, 14);
     Wait(3);

     SetAtt (  6, 11, 24, 11, 14);
     SetAtt (  6, 13, 24, 13, 112);
     PutStr ( H, Center ('Left-justify and pad a string',38,' '),
                 21,23,Att1);
     PutStr ( H, Left ('There are no miracles--', 44, ' '), 32, 13, 14);
     Wait(3);

     SetAtt (  6, 13, 24, 13, 14);
     SetAtt (  6, 15, 24, 15, 112);
     PutStr ( H, Center ('Right-justify and pad a string',38,' '),
                 21,23,Att1);
     PutStr ( H, Right ('--just discipline--', 44, ' '), 31, 15, 14);
     Wait(3);

     SetAtt (  6, 15, 24, 15, 14);
     SetAtt (  6, 16, 24, 16, 112);
     PutStr ( H, Center ('Strip leading and trailing characters',38,' '),
                 21,23,Att1);
     PutStr ( H, Right ( Strip ('--just discipline--','-'), 44, ' '),31,16,14);
     Wait(3);

     SetAtt (  6, 16, 24, 16, 14);
     SetAtt (  6, 14, 24, 14, 112);
     PutStr ( H, Center ('Overlay and pad one string on another',38,' '),
                 21,23,Att1);
     PutStr ( H, OverStr ( 'just discipline','There are no miracles--',
                         24,15,' '), 32, 14, 14);
     Wait(3);

     SetAtt (  6, 14, 24, 14, 14);
     SetAtt (  6, 12, 24, 12, 112);
     PutStr ( H, Center ('Create a string of like characters',38,' '),
                 21,23,Att1);
     PutStr ( H, Center ( Copies ( '-',13), 44, ' '), 31, 12, 14);
     Wait(3);

     SetAtt (  6, 12, 24, 12, 14);
     SetAtt (  6, 17, 24, 17, 112);
     PutStr ( H, Center ('- Uppercase Function -',38,' '),
                 21,23,Att1);
     PutStr ( H, Center ( Upper ( 'amen'), 44, ' '), 31, 17, 14);
     Wait(3);

     SetAtt (  6, 17, 24, 17, 14);
     SetAtt (  6, 18, 24, 18, 112);
     PutStr ( H, Center ('Create a string of strings',38,' '),
                 21,23,Att1);
     PutStr ( H, Center ( CopyStr ('Amen ',9), 45, ' '), 31, 18, 14);
     wait(3);

          { Flash status box on bottom }
     for i := 1 to 6 do
     begin
        SetAtt ( 21, 23, 58, 23,   0 );
        delay ( 30 );
        SetAtt ( 21, 23, 58, 23, 112 );
        delay ( 30 );
     end;
     PutStr ( H, Center ('Create a string of strings',38,' '),
                 21,23,Att1);
     wait(1);

          { Draw micro checkerboard }
     for i := 1 to 20 do
        PutStr ( h, CopyStr ('',40), 1,i,7);
     wait(2);
     RestoreScreen ( page[1] );
     Wait(4);
end { StringDemo };

{ -------------------
  VIDEO routines demo
  ------------------- }
Procedure VideoDemo;
begin

     FillHeap ( Page[2],  1,  1, 80, 25, ' ', 14 );
     BoxHeap  ( Page[2], 55,  8, 75, 10,  1, 14 );
     BoxHeap  ( Page[2], 55, 10, 75, 19,  4, 14 );
          { Draw connectors to make two boxes look like one }
     PutHeap  ( Page[2], V, #198, 55, 10, 14);
     PutHeap  ( Page[2], V, #181, 75, 10, 14);
     PutHeap  ( Page[2], H, Center ('Video Procedures', 19, ' '), 56,  9, 14);

     s := 'CopyBlk GetStr  FindStr MoveBg  MoveBlk PutStr  RemBlk  SetAtt  ';
     for i := 1 to 8 do
        PutHeap ( Page[2], H, Copy( S, 1+(i-1)*8, 8), 62, 10 + i, 14);
     RestoreScreen ( Page[2] );
     wait(2);

          { Write status block centered on bottom of screen }
     Att1 := $1E;
     Boxul ( 20, 22, 59, 24, 2, Att1 );

     SetAtt ( 56, 16, 74, 16, 112);
     PutStr ( H, Center ('Put String to display VERTICALLY',38,' '),
                 21,23,Att1);
     PutStr ( V, Copies (#$B3,12), 20,  6, 14);
     Wait(3);

     PutStr ( H, Center ('Put String to display HORIZONTALLY',38,' '),
                 21,23,Att1);
     PutStr ( H, Copies (#$C4,30), 20, 6, 14);
     PutStr ( H, #$DA, 20, 6, 14);
     Wait(3);

     SetAtt ( 56, 16, 74, 16, 14);
     SetAtt ( 56, 15, 74, 15, 112);

     SaveScreen ( page[3] );
     MblkHeap ( page[3], 20, 6, 49, 17, 10, 6);
     MblkHeap ( page[3], 10, 6, 39, 6, 10, 17);
     PutHeap  ( page[3], h, #$C0, 10, 17, 14);
     RestoreScreen ( page[3] );
     PutStr ( H, Center ('Move a Block on the display',38,' '),
                 21,23,Att1);
     wait(3);

     PutStr ( H, Center ('- PutStr again -',38,' '),
                 21,23,Att1);
     SetAtt ( 56, 15, 74, 15, 14);
     SetAtt ( 56, 16, 74, 16, 112);
     PutStr ( H, Copies ( #$DB,4 ), 38, 16, 14);
     PutStr ( H, Copies ( #$DF,4 ), 38, 17, 14);
     wait(3);

     PutStr ( H, Center ('- Copy Blocks -',38,' '),
                 21,23,Att1);
     SetAtt ( 56, 16, 74, 16, 14);
     SetAtt ( 56, 11, 74, 11, 112);
     CopyBlk ( 38, 16, 41, 16, 38, 15);
     wait(3);

     PutStr ( H, Center ('- Move them -',38,' '),
                 21,23,Att1);
     SetAtt ( 56, 11, 74, 11, 14);
     SetAtt ( 56, 15, 74, 15, 112);
     MoveBlk (38, 15, 41, 17, 13, 15);
     PutStr  ( H, Copies ( #$C4,4 ), 38, 17, 14);
     wait(3);

     PutStr ( H, Center ('- Copy more blocks -',38,' '),
                 21,23,Att1);
     SetAtt ( 56, 15, 74, 15, 14);
     SetAtt ( 56, 11, 74, 11, 112);
     for i := 1 to 3 do
        CopyBlk ( 13, 15, 16, 16, 20, 15-(i-1)*2);
     PutStr ( H, Copies ( #$DF,4 ), 20, 17, 14);

     for i := 1 to 8 do
        CopyBlk ( 13, 15, 16, 16, 27, 15-(i-1)*2);
     PutStr ( H, Copies ( #$DF,4 ), 27, 17, 14);

     PutStr ( H, #$C1, 34, 17, 14);
     wait(3);

     PutStr ( H, Center ('- PutStr some labels -',38,' '),
                 21,23,Att1);
     SetAtt ( 56, 11, 74, 11, 14);
     SetAtt ( 56, 16, 74, 16, 112);
     PutStr ( V, Center ( 'POTENCY',12,' '), 3,6,14);
     PutStr ( V, Center ( 'OF',12,' '), 5,6,14);
     PutStr ( V, Center ( 'WEAPONS',12,' '), 7,6,14);
     PutStr ( H, 'I     II    III   IV',15,18,14);
     PutStr ( H, Center ('WORLD WARS',28,' '),12,19,14);
     wait(3);

     PutStr ( H, Center ('Change display attributes',38,' '),
                 21,23,Att1);
     SetAtt ( 56, 16, 74, 16, 14);
     SetAtt ( 56, 18, 74, 18, 112);
     SetAtt ( 13, 15, 16, 16, 12);
     SetAtt ( 20, 11, 23, 16, 10);
     SetAtt ( 27,  1, 30, 16,  9);
     PutStr ( H, Copies ( #$DF,4 ), 13, 17, 12);
     PutStr ( H, Copies ( #$DF,4 ), 20, 17, 10);
     PutStr ( H, Copies ( #$DF,4 ), 27, 17,  9);
     wait(4);

     PutStr ( H, Center ('- Remove Blocks -',38,' '),
                 21,23,Att1);
     SetAtt ( 56, 18, 74, 18, 14);
     SetAtt ( 56, 17, 74, 17, 112);
     RemBlk ( 27, 1, 34, 18);
     wait(5);

     SaveScreen ( page[3] );
     HeapAt ( page[3], 56, 17, 74, 17, 14);
     HeapAt ( page[3], 56, 15, 74, 15, 112);
     FillHeap ( page[3], 35, 17, 41, 17, ' ', 14 );
     FstrHeap ( page[3], 'WOR', Xheap, Yheap );
     MblkHeap ( page[3], Xheap, Yheap, Xheap+9, Yheap, Xheap-7, Yheap);
     RestoreScreen ( page[3] );
     PutStr ( H, Center ('- Straighten up a bit -',38,' '),
                 21,23,Att1);
     wait(4);

     PutStr ( H, Center ('Hunt for string & park cursor',38,' '),
                 21,23,Att1);
     SetAtt ( 56, 15, 74, 15, 14);
     SetAtt ( 56, 13, 74, 13, 112);
     FindStr ( 1, 19, 'WO', 0, ecode );
     CursorOn;
     wait(5);

     SaveX := WhereX;
     SaveY := WhereY;
     PutStr ( H, Center ('Read display across or down',38,' '),
                 21,23,Att1);
     SetAtt ( 56, 13, 74, 13, 14);
     SetAtt ( 56, 12, 74, 12, 112);
     GetStr ( H, S, SaveX, SaveY, 10);
     SetAtt ( SaveX, SaveY, SaveX+9, SaveY, 112);
     wait(5);
     CursorOff;

     SaveScreen ( page[3] );
     HeapAt ( page[3], 56, 12, 74, 12, 14);
     HeapAt ( page[3], 56, 15, 74, 15, 112);

          { Move block left to right to affect an erase }
     MblkHeap ( page[3], 55,  7, 80, 20,  1,  7 );
     PutHeap  ( page[3], H, Center ('An alternative to RemBlk',38,' '),
                 21,23,Att1);
     RestoreScreen ( page[3] );
     wait(1);

          { Reposition block on right side of screen }
     MblkHeap (  page[3],  1,  7, 22, 20, 55,  7 );
     RestoreScreen ( page[3] );
     wait(4);

     PutHeap ( page[3], H, Center ('Take control of the screen',38,' '),
                 21,23,Att1);
     HeapAt  ( page[3], 56, 15, 74, 15, 14);
     HeapAt  ( page[3], 56, 11, 74, 11, 112);
     CblkHeap ( page[3], 55,  8, 75, 20, 30,  8 );
     CblkHeap ( page[3], 55,  8, 75, 20,  5,  8 );
     RestoreScreen ( page[3] );
     wait(4);

     SetAtt ( 56, 11, 74, 11, 14);
     SetAtt ( 30, 11, 50, 11, 14);
     SetAtt (  6, 11, 24, 11, 14);
     SetAtt ( 56, 14, 74, 14, 112);
     SetAtt ( 31, 14, 49, 14, 112);
     SetAtt (  6, 14, 24, 14, 112);

     SaveScreen ( page[3] );

          { Move status block from bottom to top of screen }
     for i := 22 Downto 3 do
     begin
        MoveBg ( page[3], 20, i, 60, i+2, 20, i-1 );
        delay(30);
     end;
     wait(1);

     PutStr ( H, Center ('Move a block over a background',38,' '),
                 21,23,Att1);

          { Flash status box on bottom }
     for i := 1 to 6 do
     begin
        SetAtt ( 21, 23, 58, 23,   0 );
        delay ( 30 );
        SetAtt ( 21, 23, 58, 23, 112 );
        delay ( 30 );
     end;

     PutStr ( H, Center ('Move a block over a background',38,' '),
                 21,23,Att1);
     wait(2);

     SaveScreen ( page[3] );

          { Move status block from bottom to top of screen }
     for i := 22 Downto 3 do
     begin
        MoveBg ( page[3], 20, i, 60, i+2, 20, i-1 );
        delay(30);
     end;
     PutStr ( H, Center ('Once was not enough',38,' '),
                 21,23,Att1);
     Wait(3);

     RestoreScreen ( page[2] );
     PutStr ( V, #196, 65,  8, 14);
     wait(1);

          { Restore overview chart }
     RestoreScreen ( page[1] );
     Wait(4);
end { VideoDemo };

{ ---------------------
  SPECIAL routines demo
  --------------------- }
Procedure SpecialDemo;
var
   TrackTime : Integer;
begin

     FillHeap ( page[3], 1, 1, 80, 25, ' ', 14 );
     BoxHeap  ( page[3], 30, 2, 51, 4, 1, 14 );
     PutHeap  ( Page[3], H, Center ('Special Routines', 19, ' '), 31, 3, 14);
     RestoreScreen ( page[3] );

          { Create and display Chorus Line }
     S := 'BoxUL     TimeXY    Cursors   Dows      Timer     Exec      '+
          'NsOrbit   Heap I/O  ';
     PutStr ( H, S, 1, 6, 112);

          { Flash chorus line ( make 'S' blink) }
     for i := 1 to 3 do
        for j := 1 to 8 do
        begin
           SetAtt ( 1+(j-1)*10, 6, 10+(j-1)*10, 6 , 14);
           delay(40);
           SetAtt ( 1+(j-1)*10, 6, 10+(j-1)*10, 6 , 112);
           delay(40);
        end;
     wait(3);

          { Draw status box centered near bottom of screen }
     Boxul ( 20, 22, 59, 24, 2, Att1 );
     PutStr ( H, Center ('Boxes : 4 styles in any attribute',38,' '),
                 21,23,Att1);
     MoveBlk ( 1, 6, 10, 6, 36, 9);
     wait(3);

          { Build four boxes in page[4] of heap }
     SaveScreen ( page[3] );
     SaveScreen ( page[4] );
     BoxHeap    ( page[4],  1, 11, 20, 19, 1,   7);
     BoxHeap    ( page[4], 21, 11, 40, 19, 2,  14);
     BoxHeap    ( page[4], 41, 11, 60, 19, 3, 112);
     BoxHeap    ( page[4], 61, 11, 80, 19, 4,  14);

     PutHeap ( page[4], h, Center ('Main Menu',18,' '), 2, 14,  7 );
     PutHeap ( page[4], h, Center ('Next Menu',18,' '),22, 14, 14 );
     PutHeap ( page[4], h, Center ('Wine Menu',18,' '),42, 14, 14 );
     PutHeap ( page[4], h, Center ('Last Menu',18,' '),62, 14,  7 );
          { Display boxes }
     RestoreScreen ( page[4] );
     wait(6);

          { Clear four boxes from screen }
     RestoreScreen ( page[3] );

           { Put BoxUL back in chorus line and get NsOrbit }
     MoveBlk ( 36, 9, 45, 9,  1, 6);
     MoveBlk ( 61, 6, 70, 6, 36, 9);


          { Draw NsOrbit box }
     BoxUL (31, 11, 50, 19, 1, 14);
     PutStr ( H, Center ('Orbit some text',38,' '),
                 21,23,Att1);
     wait(2);
     PutStr  ( h, Center ( 'Watch out for',18,' '),  32, 13, 14 );
     PutStr  ( h, Center ( 'Heavenly',18,' '), 32, 15, 14 );
     PutStr  ( h, Center ( 'Hammers',18,' '), 32, 17, 14 );
     NsOrbit ( 31, 11, 50, 19, 2, 3);
     wait(2);

          { Remove Heavenly Hammer box }
     RemBlk ( 31, 11, 50, 19 );

          { Put NsOrbit back in chorus line and get Heap I/O }
     MoveBlk ( 36, 9, 45, 9, 61, 6);
     MoveBlk ( 71, 6, 80, 6, 36, 9);

     PutStr ( H, Center ('Speed SANS snow on CGA',38,' '),
                 21,23,Att1);
     wait(2);
     PutStr ( h, Center('Display NINE screens',80,' '), 1, 13, 14);
     PutStr ( h, Center('Be back in a flash',80,' '), 1, 14, 14);
     SaveScreen ( page[3] );
     wait(3);
     j := 30;
     RestoreScreen ( page[1] );
     delay(j);
     RestoreScreen ( page[2] );
     delay(j);
     RestoreScreen ( page[4] );
     delay(j);
     RestoreScreen ( page[1] );
     delay(j);
     RestoreScreen ( page[2] );
     delay(j);
     RestoreScreen ( page[4] );
     delay(j);
     RestoreScreen ( page[1] );
     delay(j);
     RestoreScreen ( page[2] );
     delay(j);
     RestoreScreen ( page[4] );
     delay(j);
     RestoreScreen ( page[3] );
     wait(1);
     PutStr ( h, Center('And that included a 30 millisecond delay',80,' '),
                         1, 13, 14);
     PutStr ( h, Center('between displays, so they could be seen.',80,' '),
                         1, 14, 14);
     wait(5);
     MoveBlk (36, 9, 45, 9, 71, 6);
     RemBlk ( 1, 13, 80, 14 );

          { Flash status box on bottom }
     PutStr ( H, Center ('Combine tools for easy menu making',38,' '),
                 21,23,Att1);
     for i := 1 to 6 do
     begin
        SetAtt ( 21, 23, 58, 23,   0 );
        delay ( 30 );
        SetAtt ( 21, 23, 58, 23, 112 );
        delay ( 30 );
     end;
     PutStr ( H, Center ('Combine tools for easy menu making',38,' '),
                 21,23,Att1);
     wait(2);
     SaveScreen ( page[3] );

          { Display mock menu }
     Menu;

     RestoreScreen ( page[3] );
     wait(1);

     MoveBlk (41, 6, 50, 6, 36, 9);
     PutStr ( H, Center ('A Boolean Process-Timer',38,' '),
                 21,23,Att1);
     wait(2);
     PutStr ( H, #17+#196+#196+' Set the timer to 5',52, 9, 14);
     PutStr ( H, '(5)', 41,9,112);
     wait(2);

     Boxul ( 31, 11, 50, 19, 3, 14);

     TrackTime := TimeElapsed;
     i := 5;
     PutStr ( H, Center ('Process while the timer ticks',38,' '),
                 21,23,Att1);
     window ( 32, 12, 49, 18);
     gotoXY(1,1);
     repeat
        if TrackTime <> TimeElapsed then
        begin
           i := pred(i);
           TrackTime := TimeElapsed;
           SaveX := WhereX;
           SaveY := WhereY;
           PutStr ( h, chr($30+i), 42, 9, 112);
           gotoXY(SaveX,SaveY);
        end;
        write('Processing . . .  ');
     until Timer(5);
     Sound(110);
     Delay(200);
     NoSound;
     window(1,1,80,25);
     RemBlk (31,11,50,19);
     Wait(1);

     PutStr ( H, '   ', 41,9,112);
     PutStr ( H, Copies(' ',22), 52,9,14);

     MoveBlk (36, 9, 45, 9, 41, 6);

     PutStr ( H, Center ('Turn ON the cursor . . .',38,' '),
                 21,23,Att1);
     MoveBlk (21, 6, 30, 6, 36, 9);
     FindStr ( 1,9, 'Cur',9,ecode );
     CursorOn;
     wait(2);
     PutStr ( H, Center ('. . . and turn it OFF',38,' '),
                 21,23,Att1);
     CursorOff;
     wait(1);
     MoveBlk (36, 9, 45, 9, 21, 6);

     MoveBlk (11, 6, 20, 6, 36, 9);
     PutStr ( H, Center ('Set and display time of day',38,' '),
                 21,23,Att1);
     Repeat
        TimeXY ( 37, 13 );
     until Timer(6) or KeyPressed;
     if KeyPressed then
        read(Kbd,ch);
     RemBlk ( 37, 13, 47, 13 );
     MoveBlk (36, 9, 45, 9, 11, 6);
     wait(1);

     MoveBlk (31, 6, 40, 6, 36, 9);
     PutStr ( H, Center ('Day-of-the-week function',38,' '),
                 21,23,Att1);
     wait(1);

          { Display Calendars using Dows }
     SaveScreen ( page[3] );
     SaveScreen ( page[4] );
     Randomize;
     CalHeap (Page[4], 1+Random(12), 1960+Random(31), 29, 8);
     CalHeap (Page[4], 1+Random(12), 1960+Random(31), 55, 8);
     Move ( page[4]^, page[2]^, 4000 );
     CalHeap (Page[4], 1+Random(12), 1960+Random(31),  3, 8);
     PutHeap ( page[2], h, Center ('Using Movebg ',38,' '), 21,23, Att1 );
     RestoreScreen ( page[4] );
     PutStr ( H, Center ('Routine CalHeap, which uses DOWS',38,' '),
                 21,23,Att1);
     wait(20);

          { Move left-most calendar to center }
     for i := 3 to 28 do
     begin
        Movebg ( page[2],  i,  8, i+22, 22, i+1,  8 );
        delay(130);
     end;

     wait(2);
     RestoreScreen ( page[3] );

     wait(2);
     MoveBlk (36, 9, 45, 9, 31, 6);
     wait(2);
     MoveBlk (51, 6, 60, 6, 36, 9);
     PutStr ( H, Center ('Execute another program and return',38,' '),
                 21,23,Att1);
     wait(2);
     PutStr ( H, Center ('Available on BoDemo.COM',38,' '),21,13,14);
{
     SaveScreen (page[2]);

     ClrScr;
     FileDesc := 'A:\COMMAND.COM';
     ComLine  := 'command /c DIR /W';
     Exec (FileDesc,ComLine,Ecode);
     SaveScreen ( page[3] );
     Wait(2);

     FstrHeap ( page[3], 'bytes free', Xheap, Yheap );
     GetStr  (H, S, Xheap-24,Yheap, 40);

     RestoreScreen (page[2]);
     wait(2);
     Boxul ( 20, 12, 59, 14, 2, 12 );
     PutStr (H, Center ( Strip (S, ' '), 38,' '), 21, 13, 14);
     PutStr ( H, Center ('Capture output from other programs',38,' '),
                 21,23,Att1);
}
     wait(3);
     RemBlk (20, 12, 59, 14);
     MoveBlk (36, 9, 45, 9, 51, 6);
     wait(2);

     RestoreScreen ( page[1] );
end;

Procedure Closing;
begin
     CopyBlk ( 30, 15, 51, 17, 30, 19 );
     PutStr ( V, #194+#179, 40, 17, 14);
     PutStr ( H, Center ( 'Word Functions',19,' '), 31, 20, 14);
     wait(2);
     SetAtt ( 31, 20, 49, 20, 12);
     wait(2);
     Order;
     wait(60);
end;

BEGIN
   CursorOff;
                     { Allocate heap space for Npage screens }
   Mark ( HeapTop );
   for i := 1 to Npage do
      New ( page[i] );

   Repeat
      Opening;
      OverView;
      StringDemo;
      VideoDemo;
      SpecialDemo;
      Closing;
   Until KeyPressed;

   CursorOn;
   Release ( HeapTop );
END.
