Type
   AnyString   =  string[255];
   HeapBuf     = ^AnyBuf;
   AnyBuf      =  Record
                     Screen : array[1..4000] of byte;
                  end;
   ColumnType  =  1..80;      { With $R directive active, }
   RowType     =  1..25;      { keeps video routines in line }
   result      =  Record
                     AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : Integer;
                  end;

Var

   TimeElapsed,               { Used by Etime . . . }
   SaveElapsed,               { "    "  "           }
   Ecode,                     { "    "  Exec for error return }
   I                          { the ubiquitous index variable  }
                     : Integer;
   SaveX                      { handy for saving WhereX result }
                     : ColumnType;
   SaveY                      { "     "   "      WhereY "      }
                     : RowType;
   Xheap             : ColumnType;
   Yheap             : RowType;
   HeapTop           : ^Integer;  { for marking current top of heap }

   Ch                         { as in read(Kbd,ch) after KeyPressed }
                     : Char;

   page                       { screens for SaveScreen, RestoreScreen,
                                and MoveBg }
                     : array[1..2] of HeapBuf;

   VideoStatus       : byte   absolute $0000:$0449;
   MonoBuffer        : AnyBuf absolute $B000:0000;
   GraphicsBuffer    : AnyBuf absolute $B800:0000;
   Regs              : Result;

   S,                         { general string array }
   FileDesc,                  { File name and extension for EXEC }
   ComLine                    { Command Line setting for EXEC    }
                     : AnyString;



Const
   H  = 'H';                  { Code for horizontal PutStr & GetStr }
   V  = 'V';                  { "    "   vertical   "      " "      }
   StartElapsed : Boolean = FALSE;
                              { Initial value for etime function    }