Unit Com;
{$O+,F+}

interface


procedure send(_port:word; s:String);
procedure ups(var s:string);
procedure cls;
procedure nl; { New Line    }
procedure bs; { Back Spaces }
procedure cwrite(s:string);
procedure cwriteln(s:string);
procedure nwrite(s:string);
procedure nwriteln(s:string);
function creadkey : char;
function ckeypressed : boolean;
procedure creadln(var s:string);
{ Echos 'char' instead of the actual input characters.  For PW input }
procedure ereadln(var s:string; echo_char:char);
procedure ureadln(var s:string); { UPCASE readln }
procedure uereadln(var s:string; echo_char:char); { UPCASE Ereadln }

implementation
uses async,crt;

procedure cwrite(s:string);
var i:integer;
begin
   for i:= 1 to length(s) do
   begin
      if cdetect then transmit(s[i]);
      write(s[i]);
   end;
end;

procedure cwriteln(s:string);
begin
   cwrite(s+chr(13)+chr(10));
end;

procedure nwrite(s:string);
var i:integer;
begin
   for i := 1 to length(s) do
   begin
      if cdetect then transmit(s[i]);
   end;
end;

procedure nwriteln(s:string);
begin
   nwrite(s+chr(13)+chr(10));
end;

function creadkey : char;
begin
   repeat until (keypressed) or (charwaiting);
   if charwaiting and cdetect then creadkey := receive else
   if keypressed then creadkey := readkey;
end;

function ckeypressed : boolean;
begin
   ckeypressed := (keypressed) or (charwaiting and cdetect);
end;

procedure bs;
begin
   cwrite(^H+' '+^H);
end;

procedure nl;
begin
   cwrite(#10+#13);
end;

procedure creadln(var s:string);
var c:char;
begin
   s := '';
   repeat
      c := creadkey;
      if ord(c) in [32..255] then
      begin
         s := s + c;
         cwrite(c);
      end else
      if (c=#8) and (length(s)>0) then
      begin
         bs;
         delete(s,length(s),1);
      end;
   until c=#13;
   cwriteln('');
end;

procedure ereadln(var s:string;echo_char:char);
var c:char;
begin
   s := '';
   repeat
      c := creadkey;
      if ord(c) in [32..255] then
      begin
         s := s + c;
         cwrite(echo_char);
      end else
      if (c=#8) and (length(s)>0) then
      begin
         bs;
         delete(s,length(s),1);
      end;
   until c=#13;
   cwriteln('');
end;

procedure uereadln(var s:string;echo_char:char);
var c:char;
begin
   s := '';
   repeat
      c := upcase(creadkey);
      if ord(c) in [32..255] then
      begin
         s := s + c;
         cwrite(echo_char);
      end else
      if (c=#8) and (length(s)>0) then
      begin
         bs;
         delete(s,length(s),1);
      end;
   until c=#13;
   cwriteln('');
end;

procedure cls;
begin
   nwrite('[2J');
   clrscr;
end;

procedure ureadln(var s:string);
var c:char;
begin
   s := '';
   repeat
      c := upcase(creadkey);
      if ord(c) in [32..255] then
      begin
         s := s + c;
         cwrite(c);
      end else
      if (c=#8) and (length(s)>0) then
      begin
         bs;
         delete(s,length(s),1);
      end;
   until c=#13;
   cwriteln('');
end;

procedure ups(var s:string);
var i:integer;
begin
   if length(s) > 0 then
   begin
   for i := 1 to length(s) do
   begin
      s[i] := upcase(s[i]);
   end;
   end;
end;

procedure send(_port:word;s:string);
var b:byte;
begin
   for b := 1 to length(s) do
   begin
      port[_port] := ord(s[b]);
   end;
end;

end.