UNIT Async;
{$F+,O+}

INTERFACE

procedure Transmit(ch1:char);
function Receive:char;
procedure FlushComm;
function  CharWaiting:BOOLEAN;
function  CDetect:boolean;
procedure Init(port_num:byte; baud : longint);
procedure Shutdown;
function Ringing : boolean;

IMPLEMENTATION

USES DOS;

type
   buffer = array[1..65535] of byte;

CONST
   bit0 = $01; {Bits to use with AND masks}
   bit1 = $02;
   bit2 = $04;
   bit3 = $08;
   bit4 = $10;
   bit5 = $20;
   bit6 = $40;
   bit7 = $80;
   port_base_id : array[0..4] of word = (0,$3f8,$2f8,$2e8,$3e8);
   port_IRQ : array[0..4] of byte = (0,4,3,4,3);


  IER=1;
  FCR=2;
  IIR=2;
  LCR=3;
  MCR=4;
  LSR=5;
  MSR=6;

VAR

  buf_head,buf_tail : word;
  com_buf : array[0..1024] of byte;
  buf : ^buffer;
  async_irq,port_base : word;


PROCEDURE Disable; INLINE($FA);
PROCEDURE Enable;  INLINE($FB);


Function Ringing : boolean;
begin
   if port[port_base+MSR] and bit6 = bit6 then ringing := true;
end;

{$F+}                                 { Make it a FAR function }
PROCEDURE isr; INTERRUPT;
BEGIN
  buf^[buf_head]:=port[port_base];
  inc(buf_head);
  IF buf_head = 65535 THEN
    buf_head := 0;
  port[$20]:=$20;
END;
{$F-}

PROCEDURE Transmit(ch1:CHAR);
VAR
  temp : BYTE;
BEGIN

  repeat
    temp:=port[port_base + LSR] AND $20;
  until temp<>0;

  port[port_base]:=integer(ch1);
END;

FUNCTION  CharWaiting:BOOLEAN;
BEGIN
  charwaiting := buf_head<>buf_tail;
END;


FUNCTION  Receive:char;
VAR
  c1 : char;
BEGIN

  if buf_head <> buf_tail then
  BEGIN
    disable;
    c1 := char(buf^[buf_tail]);
    inc(buf_tail);
    if buf_tail = 65535 then
      buf_tail := 0;
    enable;
    receive:=c1;
  END  else
    receive:=#0;
END;

PROCEDURE FlushComm;
BEGIN
  disable;
  buf_head :=0;
  buf_tail :=0;
  enable;
END;

PROCEDURE dtr(i : BOOLEAN);
VAR
  i1 : word;
BEGIN
  i1 := port[port_base + MCR] AND $00FE;
  if i then
  port[port_base + MCR]:= i1+1 else
  port[port_base + MCR] := i1;
END;

FUNCTION  CDetect:boolean;
BEGIN
  cdetect := (port[port_base + MSR] AND $0080)<> 0;
END;

PROCEDURE Init(port_num : byte; baud : longint);
VAR
  temp : word;
  tmp : word;
  brd : word;

BEGIN
  new(buf);
  brd := 115200 div baud;
  case port_num of
  1 : port_base := $3F8;
  2 : port_base := $2F8;
  3 : port_base := $3E8;
  4 : port_base := $2E8;
  end;
  async_irq := port_IRQ[port_num];
  setintvec(8 + async_irq, addr(isr));
  buf_head :=0;
  buf_tail := 0;
  disable;
  temp := port[port_base + LSR];        { Read LSR to reset all bits }
  temp := port[port_base];              { clear any character still pending }
  temp := port[$21];                    { read the PIC mask }
  temp := temp AND((1 SHL async_irq)XOR $00FF);  {set appropriate bit }
  port[$21]:=temp;                      {set the PIC mask appropriately}
  port[port_base + IER]:=1;
  temp:=port[port_base + MCR];
  port[port_base + MCR]:= temp OR $0A;  {Set MCR }
  port[port_base + FCR]:=$c0;           {enable FIFO's on 16550A's }
  enable;
  port[port_base+LCR] := bit7;
  port[port_base+$00] := lo(brd);
  port[port_base+$01] := hi(brd);
  port[port_base+LCR] := port[port_base+LCR] XOR bit7;
  port[port_base+LCR] := $03;
  dtr(TRUE);
END;

PROCEDURE Shutdown;
VAR
  temp : integer;
  oldvec : pointer;
BEGIN
  if port_base<>0 then BEGIN
    disable;
    temp := port[$21];
    temp := temp OR ((1 SHL async_irq));  { unmask the PIC }
    port[$21]:= temp;
    port[port_base + IIR]:=0;             { shutdown the interrupts }
    port[port_base + MCR]:=3;
    getintvec(8,oldvec);
    setintvec(async_irq+8,oldvec);
    enable;
    port_base:=0;
    dispose(buf)
  END;
END;

END.

