Program  Cool_Split_Screen_ANSI_Chat;       {Simplex}
{$I+}
uses
 dos,CRT;


Type
 CfgRecord=Record
            CommFile:File of byte;           {File to assign to Comport}
            Idx,addr:word;                   {CommPort# & Address}
            LocalName,Init,Dial:string[40];  {Duh}
            Baud:longint;                    {Can you figure this one out?}
           end;


Var
 Cfg:CfgRecord;                              {The config Record}
 RemoteName:string;                          {Remote login name}
 Bo,Local,Inchat:boolean;                    {Various switches}
 Tc,Bc:String[2];                            {Text & Background colors}
 Savex,Savey:byte;                           {Store X & Y position}
 c:char;                                     {All purpose Character}

{--------------------------------------------------------------------}

Function RD:boolean;                {Gets the Reciving bit from modem}

begin
 RD:=(Port[cfg.addr+5]and$1=$1);
end;

{--------------------------------------------------------------------}

Function CD:boolean;                {Carrier detect, may not always work}

begin
 CD:=(Port[cfg.addr+6]and$80<>$80);
end;

{--------------------------------------------------------------------}

Procedure SetBaud(rate:longint);    {Set port's baud rate}

var
 divisor:word;

begin
 Divisor:=115200 Div rate;
 Port[cfg.addr+3]:=Port[cfg.addr+3]OR$80;
 Port[cfg.addr]:=Lo(Divisor);
 Port[cfg.addr+1]:=Hi(Divisor);
 Port[cfg.addr+3]:=Port[cfg.addr+3]AND(NOT$80);
end;

{--------------------------------------------------------------------}

Function Incoming:boolean;          {Sends true if keypressed or RD}

Begin
 if local then
 incoming:=(keypressed)else
 incoming:=(keypressed or RD);
end;

{--------------------------------------------------------------------}

function getscreenword(x,y:byte):word;
{Grabs the screen value @X,Y, Div 256=ATTR, Mod 256=Char}

begin
 getscreenword:=memw[$b800:(x*2)+(Y*160)];
end;

{--------------------------------------------------------------------}

Function Comreadkey:Char;           {Like readkey, includes modem}

var
 b:byte;

begin
 repeat until incoming;
 if keypressed or local then b:=ord(readkey) else
  read(cfg.commfile,b);
 comreadkey:=chr(b);
end;

{--------------------------------------------------------------------}

Procedure sendchar(ch:char);        {Send single character to modem}

var
 b:byte;

begin
 b:=ord(ch);
 if not local then write(cfg.commfile,b);
end;

{--------------------------------------------------------------------}

Procedure sendString(str:string);   {Send string to modem}

var
 count:integer;
 b:byte;

begin
 for count := 1 to length(str) do
 begin
  b:=ord(str[count]);
  write(cfg.commfile,b);
 end;
end;

{--------------------------------------------------------------------}

PROCEDURE ComWrite(Strn : String);  {Write Strn to modem & screen}

Var
 Idx : Byte;
 Pad : Byte;

begin
 for Idx := 1 to Length(Strn) do
 begin
  SendChar(Strn[Idx]);
  write(strn[idx]);
 end;
end;

{--------------------------------------------------------------------}

PROCEDURE ComWriteLn(Strn : String);{Writeln Strn to modem & screen}

begin
 ComWrite(Strn+#13+#10);
end;

{--------------------------------------------------------------------}

Procedure CursorUp(y:byte);         {Ansi call for moving cursor up Y}

var
 ys:string;

begin
 str(y,ys);
 If Not Local Then Sendstring(concat('[',ys,'A'));
 gotoxy(wherex,wherey-y);
end;

{--------------------------------------------------------------------}

Procedure CursorDown(y:byte);       {Ansi call for moveing cursor down Y}

var
 ys:string;

begin
 str(y,ys);
 If Not Local Then Sendstring(concat('[',ys,'B'));
 gotoxy(wherex,wherey+y);
end;

{--------------------------------------------------------------------}

Procedure CursorForward(x:byte);    {Ansi call for moveing cursor right X}

var
 xs:string;

begin
 str(x,xs);
 If Not Local Then Sendstring(concat('[',xs,'C'));
 gotoxy(wherex+x,wherey);
end;

{--------------------------------------------------------------------}

Procedure CursorBackward(x:byte);   {Ansi call for moveing cursor left X}

var
 xs:string;
begin
 str(x,xs);
 If Not Local Then Sendstring(concat('[',xs,'D'));
 gotoxy(wherex-x,wherey);
end;

{--------------------------------------------------------------------}

PROCEDURE ComReadLn(Var Strn:String;Notlocal:boolean);
{Reads a string from modem or keyboard, If notlocal and a key is
 pressed it wil send this abort string ''}

var
 c:char;
 Temp:string;

begin
 Temp:='';
 repeat
  if notlocal then
   begin
    repeat until incoming;
    if keypressed then
    begin
     strn:='';
     exit;
    end else
    if rd then c:=comreadkey;;
  end
  else c:=comreadkey;
  if c=''then                  {If backspace}
  begin
   cursorbackward(1);
   comwrite(' ');
   delete(temp,length(temp),1);
  end else
  temp:=concat(temp,c);
  comwrite(c);
 until(c=#10)or(c=#13);
 delete(temp,length(temp),1);
 strn:=temp;
 comwriteln('');
end;

{--------------------------------------------------------------------}

Procedure ClearScreen;
{Clears the screen, must call instead of clrscr, else window will be
 messed up, Also sends ansicode to clear screen}

var
 count:integer;

begin
 clrscr;
 textcolor(1);
 gotoxy(1,24);
 for count:=2 to 78 do write('');
 gotoxy(1,1);
 memw[$b800:3996]:=$0100+205;
 If Not Local Then Sendstring('[2J');
end;

{--------------------------------------------------------------------}

Procedure SetScreen(text,back:byte);{Set local color attributes}

begin
 if Bo then text:=text+8;
 textcolor(text);
 textbackground(back);
end;

{--------------------------------------------------------------------}

Procedure Colors(Text,Back:byte);{Changes set attributes and sends ansis}
var
 Looper:integer;
 OutString:String;

begin
 case Text of
  0:Tc := '30';
  1:Tc := '34';
  2:Tc := '32';
  3:Tc := '36';
  4:Tc := '31';
  5:Tc := '35';
  6:Tc := '33';
  7:Tc := '37';
 end;
 case Back of
  0:Bc := '40';
  1:Bc := '44';
  2:Bc := '42';
  3:Bc := '46';
  4:Bc := '41';
  5:Bc := '45';
  6:Bc := '43';
  7:Bc := '47';
 end;
 OutString := concat('[',Tc,';',bc,'m');
 if not local Then Sendstring(outstring);
 setscreen(text,back);
end;

{--------------------------------------------------------------------}

Procedure Bold;                 {Sets BO to true, sends ansi}

var
text,back,error:integer;

begin
 If Not Local Then Sendstring('[1m');
 bo := true;
 val(tc,Text,error);
 val(bc,Text,error);
 setscreen(text,back);
end;

{--------------------------------------------------------------------}

Procedure ResetAttr;            {Reset BO, sends ansi}

var
text,back,error:integer;

begin
 If Not Local Then Sendstring('[0m');
 Bo := false;
 val(tc,text,error);
 val(bc,back,error);
 setscreen(text,back);
end;

{--------------------------------------------------------------------}

Procedure Moveto(x,y:integer);  {Moves cursor, sends ansi}

var
xs,ys:string;

begin
 if y<1 then y := 1;
 if x<1 then x := 1;
 str(x,xs);
 str(y,ys);
 If Not Local Then Sendstring(concat('[',ys,';',xs,'H'));
 crt.gotoxy(x,y);
end;

{--------------------------------------------------------------------}

Procedure SaveCursorPos;
{Store cursor position in storex,storey, sends ansi}

begin
 If Not Local Then Sendstring('[s');
 savex := wherex;
 savey := wherey;
end;

{--------------------------------------------------------------------}

Procedure RestoreCursorPos;
{Restores position stored in storex,storey, sends ansi}

begin
 gotoxy(savex,savey);
 If Not Local Then Sendstring('[u');
end;

{--------------------------------------------------------------------}

Procedure EraseLine;            {Erase to end of line, sends ansi}

begin
 If Not Local Then Sendstring('[K');
 clreol;
end;

{--------------------------------------------------------------------}

Function AniComReadkey:Char;    {Spinning pause prompt, gota love it}

var
 AniString:string[20];
 Position,col,setcol:integer;
 Cols:string[2];

begin
 position := 2;
 case random(5)+1 of
  1:AniString:='\-/';          {Put your own series or characters here}
  2:AniString:='/-\';          {to add new prompts, make sure random  }
  3:anistring:='<>';          {is set for the number of strings      }
  4:Anistring:='';
  5:anistring:='';
 end;
 comwrite(anistring[1]);
 setcol:=lo(textattr);
 repeat
  col:=random(7)+1;
  textcolor(col);
  col:=col+30;
  str(col,cols);
  cursorbackward(1);
  If Not Local Then Sendstring('['+cols+'m');
  comwrite(anistring[position]);
  if position<length(AniString) then inc(position) else position := 1;
  delay(100);
 until incoming;
 textcolor(setcol);
 AniComReadkey:=comreadkey;
 cursorbackward(1);
 write(' ');
end;

{--------------------------------------------------------------------}

procedure hangup;               {Hangs up modem}

begin
 sendstring('ATS0=0H'+#13);
 port[cfg.addr+4]:=0;           {Drops DTR, works pretty well}
 textcolor(15);
 writeln('Hanging up line...');
 delay(3000);
end;

{--------------------------------------------------------------------}

Procedure setup;                {Change the config file}

var
 cfgfile:file of cfgrecord;
 c:char;
 count:integer;

begin
 with cfg do
 begin
  local:=true;
  Clearscreen;
  textcolor(14);
  Writeln('Welcome to Chat Setup :');
  textcolor(15);
  writeln;
  write('Which comport is your modem on? (1-4) :');
  c:=Readkey;
  case c of
   '1':idx:=1;
   '2':idx:=2;
   '3':idx:=3;
   '4':idx:=4;
  end;
  gotoxy(1,3);
  clreol;
  textcolor(14);
  writeln('Choose a baud rate:');
  textcolor(15);writeln;
  writeln('  1: 1200bps.');
  writeln('  2: 2400bps.');
  writeln('  3: 4800bps.');
  writeln('  4: 9600bps.');
  writeln('  5: 14400bps.');
  writeln('  6: 19200bps.');
  writeln('  7: 38400bps.');
  writeln('  8: 57600bps.');
  writeln('  9: 115200bps.');
  gotoxy(20,3);
  repeat
   c:=readkey;
  until (ord(c)>48)and(ord(c)<58);
  case c of
   '1':baud:=1200;
   '2':baud:=2400;
   '3':baud:=4800;
   '4':baud:=9600;
   '5':baud:=14400;
   '6':baud:=19200;
   '7':baud:=38400;
   '8':baud:=57600;
   '9':baud:=115200;
  end;
  for count:=3 to 13 do
  begin
   gotoxy(1,count);
   clreol;
  end;
  gotoxy(1,3);
  write('What initilization string do you want? :');
  readln(init);
  gotoxy(1,3);
  clreol;
  write('What Dial string do you want? :');
  readln(Dial);
  gotoxy(1,3);
  clreol;
  write('What is the name you want to display in your window? :');
  readln(LocalName);
  gotoxy(1,3);
  clreol;
  writeln('Thank you');
  case idx of
   1:addr:=$3F8;
   2:addr:=$2F8;
   3:addr:=$3E8;
   4:addr:=$2E8;
  end;
  assign(cfgfile,'Chat.cfg');   {Assign file}
  rewrite(cfgfile);             {Rewrite file}
  write(cfgfile,cfg);           {Write Cfg}
  close(cfgfile);               {Close CfgFile}
  textcolor(15);
  writeln('File saved as "CHAT.CFG"');
  delay(2000);
  clearscreen;
 end;
end;

{--------------------------------------------------------------------}

FUNCTION Chat : Boolean;  { This is the actual procedure to chat }
                          { Kinda big huh?}
Procedure Chating;        { Actually handles chating}

var
Vx,Vy,Ux,Uy,loop:integer;

Procedure Clearwin(Win:integer);
                          {Clear top(1) or bottom(2) window}
var
loop:integer;

begin
 Bold;
 moveto(1,12);
 colors(6,1);comWrite('==');
 colors(7,1);comwrite('Ansi-Chat');
 Colors(6,1);comwrite('===========');
 colors(7,1);comwrite('Press Ctrl-R to reset your window');
 colors(6,1);comwrite('=======================');
 colors(7,0);
 moveto(1,13);
 eraseline;
 comwrite(Remotename);
 moveto(1,1);
 eraseline;
 comwrite(Cfg.Localname);
 Textcolor(15);System.Write(': Press ');
 textcolor(12);System.write('Alt-Q');
 Textcolor(15);System.write(' to exit chat');
 colors(7,0);
 case win of
  1:begin
     for loop := 2 to 11 do
     begin
      moveto(1,loop);
      eraseline;
     end;
     vx := 1;
     vy := 2;
     moveto(vx+1,vy);
    end;
  2:begin
     for loop := 14 to 23 do
     begin
      moveto(1,loop);
      eraseline;
     end;
     ux := 1;
     uy := 14;
     moveto(ux+1,uy);
    end;
 end;
end;

Procedure BackSpace(var x,y:integer);
                          {Handle backspace key}
begin
 moveto(x,y);
 if x>1 then
 begin
  cursorbackward(1);
  comwrite(#0);
  x := x-1;
  cursorbackward(1);
 end
 else
 if (Y<>2)and(y<>14)then
 begin
  y := y-1;
  x := 79;
  repeat     {This loop repeats until it reaches the last char that has been}
   x:=x-1;   {been written to}
  until ((getscreenword(x,y)div 256)<>15)or(x=1);
  moveto(x,y);
  Comwrite(#0);
  cursorbackward(1);
 end;
end;

Procedure Quitchat;             {Handle Alt-Q press by sysop}

var
 c:char;

begin
 gotoxy(1,12);
 textcolor(15+blink);
 Textbackground(4);
 write('                     ARE YOU SURE YOU WANT TO QUIT (Y/N):                     ');
 colors(3,0);
 gotoxy(vx,vy);
 c:=upcase(readkey);
 if c='Y'then inchat:=false;
 moveto(1,12);
 colors(6,1);comWrite('==');
 colors(7,1);comwrite('Ansi-Chat');
 Colors(6,1);comwrite('===========');
 colors(7,1);comwrite('Press Ctrl-R to reset your window');
 colors(6,1);comwrite('=======================');
 colors(3,0);
 gotoxy(vx,vy);
end;

begin                           {Begin chating procedure}
 clearscreen;
 clearwin(2);
 clearwin(1);
 moveto(vx,vy);
 While (inChat) do
 begin
  if incoming then
  if keyPressed then
  begin                         {Sysop Input}
   colors(3,0);
   c := Readkey;
   if(c=#0)and(readkey='')then quitchat;
   if (c<>chr(10)) and (c<>Chr(13))then
   begin
    if c = '' then
    begin                       {Sorry, I'm to lazy to notate all this}
     clearwin(1);
     c := '';
    end;
    if c=''then Backspace(vx,vy);
    if(vx<79)then
    begin
     moveto(vx,vy);
     If(C<>'')Then
     begin
      Comwrite(c);
      vx := vx+1;
     end;
    end
    else
    begin
     vx := 1;
     vy := vy+1;
     if vy>11 then clearwin(1);
     moveto(vx,vy);
     If(C<>'')Then
     begin
      Comwrite(c);
      vx := vx+1;
     end;
    end;
   end
   else
   begin
    vx := 1;
    vy := vy+1;
    if vy>11 then clearwin(1);
    moveto(vx,vy);
   end;
  end
  else
  begin                         {User Input}
   colors(2,0);
   c := comreadkey;
   if (c<>chr(10)) and (c<>Chr(13))then
   begin
    if c = '' then
    begin
     clearwin(2);
     c := '';
    end;
    if c=''then Backspace(ux,uy);
    if(ux<79)then
    begin
     moveto(ux,uy);
     If(C<>'')Then
     begin
      Comwrite(c);
      ux := ux+1;
     end;
    end
    else
    begin
     ux := 1;
     uy := uy + 1;
     if uy>23 then clearwin(2);
    moveto(ux,uy);
     If(C<>'')Then
     begin
      Comwrite(c);
      ux := ux+1;
     End;
    end;
   end
   else
   begin
    ux := 1;
    uy := uy + 1;
    if uy>23 then clearwin(2);
    moveto(ux,uy);
   end;
  end;
 end;
end;


begin                           {Begin Chat procedure}
 InChat := True;
 while (InChat) do Chating;
 Chat := False;
 resetattr;
 clearscreen;
 colors(7,0);
 comwriteln('Goodbye '+remotename+' please call again');
 hangup;
end;

{--------------------------------------------------------------------}

Procedure Login;                {Login user}

Begin
 resetattr;
 clearscreen;
 bold;
 colors(6,0);
 comwriteln('Welcome to ANSI chat :');
 comwriteln('');
 colors(1,0);
 comwrite('Please enter you name :');
 Resetattr;
 colors(2,0);
 comreadln(remotename,true);
 if remotename = '' then remotename:='Remote user';
 comwriteln('');
 comwriteln('');
 bold;
 colors(7,0);
 comwrite('Thank you, press any key to start : ');
 Anicomreadkey;
end;

{--------------------------------------------------------------------}

Procedure InitChat;             {Start up chat}

Var
 count:integer;
 DirInfo: SearchRec;
 CfgFile: File of CfgRecord;

Begin
 local:=true;
 Randomize;
 textmode(3);
 window(1,1,80,25);
 textbackground(0);
 textcolor(1);
 clearscreen;
 write('͵');
 textbackground(1);
 Textcolor(14);Write(' ANSI Chat ');
 textcolor(15);Write('By Slack ');
 textcolor(1);textbackground(0);
 write('ͻ');
 for count:=2 to 24 do
 begin
  gotoxy(1,count);write('');
  gotoxy(80,count);write('');
 end;
 write('');
 for count:=1 to 78 do write('');
 memw[$b800:3998]:=$01BC;
 window(2,2,79,25);
 textbackground(0);
 clearscreen;
 checkbreak:=False;
 FindFirst('Chat.cfg',0, DirInfo); { Same as DIR *.PAS }
 if (doserror<>0)or(paramstr(1)='S')or(paramstr(1)='s')then Setup;
 local:=false;
 filemode:=2;
 Assign(CfgFile,'Chat.cfg');
 Reset(CfgFile);
 read(cfgfile,cfg);
 close(cfgfile);
 setbaud(cfg.baud);
 with cfg do
 begin
  case idx of
   1:assign(commfile,'COM1');
   2:assign(commfile,'COM2');
   3:assign(commfile,'COM3');
   4:assign(commfile,'COM4');
  end;
  reSet(commfile);
  for count:=0 to 5 do
  port[addr+count]:=255;
  sendstring(init);
  local:=true;
 end;
end;

{--------------------------------------------------------------------}

Procedure dialout;              {Connect by dialing out}

var
str:string;

begin
 Write('Enter the number to dial :');
 textcolor(2);readln(str);
 textcolor(14);
 writeln('Dialing out...');
 textcolor(15);
 local:=false;
 sendstring(cfg.dial+str);
 repeat until cd or keypressed;
 comreadln(str,true);
 if str<>''then
 begin
  Login;
  While Chat do;
 end else begin
 writeln;
 textcolor(4);writeln('Local abort...');
 hangup;
 end;
end;

{--------------------------------------------------------------------}

Procedure AnswerCall;           {Wait for caller}

var
str:string;

begin
 Textcolor(14);
 writeln('Waiting for caller...');
 local:=false;
 sendstring('ATS0=1'+#13);
 textcolor(15);
 comreadln(str,true);
 delay(2000);
 comreadln(str,true);
 if str<>''then
 comreadln(str,true);
 if str<>''then
 begin
  comwrite('Press Esc to Log-In ');
  repeat until anicomreadkey='';
  Login;
  Local:=false;
  While Chat do;
 end else
 begin
  writeln;
  textcolor(4);writeln('Local abort...');
  hangup;
 end;
end;

{--------------------------------------------------------------------}

Procedure runsetup;             {Call setup from menu}

begin
 ClearScreen;
 textcolor(14);
 writeln('Current settings for ANSI Chat are :');
 writeln;
 Textcolor(15);write('  Comport      : ');
 Textcolor(11);writeln('COM',cfg.idx);
 Textcolor(15);write('  Port Address : ');
 Textcolor(11);
 case cfg.idx of
  1:writeln('3F8');
  2:writeln('2F8');
  3:writeln('3E8');
  4:writeln('2E8');
 end;
 Textcolor(15);write('  Baud Rate    : ');
 Textcolor(11);writeln(cfg.baud,'bps');
 Textcolor(15);write('  Local Name   : ');
 Textcolor(11);writeln(cfg.Localname);
 Textcolor(15);write('  Init String  : ');
 Textcolor(11);writeln(cfg.init);
 Textcolor(15);write('  Dial String  : ');
 Textcolor(11);writeln(cfg.dial);
 textcolor(14);
 writeln;
 write('Do you want to change these settings? (Y/N) :');
 if upcase(anicomreadkey)='Y'then
 begin
  Setup;
  clearscreen;
  Colors(4,0);
  Write('Restarting ANSI Chat with new parameters...');
  Anicomreadkey;
  writeln;
  hangup;
  window(1,1,80,25);
  textcolor(7);
  textbackground(0);
  close(cfg.commfile);
  initchat;
 end;
end;

{--------------------------------------------------------------------}

Procedure UserSession;          {Main controlling body, control menu}

Var
 Str:string;

begin
 ResetAttr;
 Savex := 0;
 Savey := 0;
 Tc := '37';
 Bc := '40';
 clearscreen;
 repeat
  sendstring('ATZS0=0'+#13);
  while keypressed do readkey;
  Local:=true;
  clearscreen;
  Textcolor(15);
  Writeln('Choose one :');
  writeln;
  textcolor(1);Write('[');
  textcolor(11);Write('D');
  textcolor(1);Write(']ial   [');
  textcolor(11);Write('A');
  textcolor(1);Write(']nswer   [');
  textcolor(11);Write('S');
  textcolor(1);Write(']etup   [');
  textcolor(11);Write('Q');
  textcolor(1);Write(']uit : ');
  textcolor(2);c:=upcase(AniComReadkey);
  Writeln(c);
  textcolor(1);
  writeln;
  case c of
   'D':Dialout;
   'A':AnswerCall;
   'S':RunSetup;
   'Q':begin
   Textcolor(4);
   writeln;
   writeln;
   write('Are you sure you want to quit? (Y/N) :');
   if upcase(anicomreadkey)<>'Y'then c:=#0;
   writeln;
  end;
  end;
 until(c='Q');
end;

{--------------------------------------------------------------------}

begin                           {This is the main program, right?}
 InitChat;
 usersession;

 hangup;                        {Last quiting procedures to call}
 Close(cfg.commfile);
 window(1,1,80,25);
 textcolor(7);
 textbackground(0);
 clrscr;
 Writeln('Thank you for using ANSI Chat');
end.
