{ Sorts & Search }

var Data:array[0..5000] of longint;

{  BinarySearch  }
function BinSearch(Srh:longint;Start_,End_:integer):integer;
var L,R,M:integer;
begin
  L:=Start_; R:=End_;
  repeat
    M:=(L+R) shr 1;
    if Srh<Data[M] then R:=M-1 else if Srh>Data[M] then L:=M+1
      else begin BinSearch:=M; Exit; end;
  until L>R;
  BinSearch:=-1;
end;
{  BubbleSort  }
procedure BubbleSort(N:integer);
var I,J:integer;
    T:longint;
begin
  for I:=1 to N-1 do begin
    J:=I;
    while (J>0) and (Data[J]>Data[J+1]) do begin
      T:=Data[J]; Data[J]:=Data[J+1]; Data[J+1]:=T;
      Dec(J);
    end;
  end;
end;
{  SelectSort  }
procedure SelectSort(N:integer);
var I,J,K:integer;
    T:longint;
begin
  for I:=1 to N-1 do begin
    K:=I;
    for J:=I+1 to N do if Data[K]>Data[J] then K:=J;
    if I<>K then begin T:=Data[I]; Data[I]:=Data[k]; Data[K]:=T; end;
  end;
end;
{  InsertSort  }
procedure InsertSort(N:integer);
var I,J:integer;
    T:longint;
begin
  Data[0]:=-1;
  for I:=2 to N do begin
    T:=Data[I]; J:=I-1;
    while T<Data[J] do begin Data[J+1]:=Data[J]; Dec(J) end;
    Data[J+1]:=T;
  end;
end;
{  ShellSort  }
procedure ShellSort(N:integer);
var I,J,Done:integer;
    T:longint;
begin
  J:=N;
  while J>1 do begin
    J:=J shr 1;
    repeat
      Done:=1;
      for I:=1 to N-J do if Data[I]>Data[I+J] then begin
	T:=Data[I]; Data[I]:=Data[I+J]; Data[I+J]:=T;
	Done:=0;
      end;
    until Done=1;
  end;
end;
{  HeapSort  }
procedure HeapSort(N:integer);
procedure Adjust(I,N:integer);
var J:integer;
    T:longint;
begin
  T:=Data[I]; J:=I shl 1;
  while J<=N do begin
    if (J<N) and (Data[J]<Data[J+1]) then Inc(J);
    if T>=Data[J] then begin Data[J shr 1]:=T; Exit; end
      else begin Data[J shr 1]:=Data[J]; J:=J shl 1; end;
  end;
  Data[J shr 1]:=T;
end;
var I:integer;
    T:longint;
begin
  for I:=N shr 1 downto 1 do Adjust(I,N);
  for I:=N-1 downto 1 do begin
    T:=Data[I+1]; Data[I+1]:=Data[1]; Data[1]:=T;
    Adjust(1,I);
  end;
end;
{  QuickSort  }
procedure QuickSort(L,R:integer);
var I,J:integer;
    M,T:longint;
begin
  I:=L; J:=R; M:=Data[(L+R) shr 1];
  repeat
    while Data[I]<M do Inc(I);
    while M<Data[J] do Dec(J);
    if I<=J then begin
      T:=Data[I]; Data[I]:=Data[J]; Data[J]:=T;
      Inc(I); Dec(J);
    end;
  until I>J;
  if L<J then QuickSort(L,J);
  if I<R then QuickSort(I,R);
end;
{  CombSort  }
procedure CombSort(N:integer);
var I,Flag:integer;
    T,Gap:longint;
begin
  Gap:=N;
  repeat
    Flag:=0; Gap:=Gap*10 div 13;
    if Gap=0 then Gap:=1 else if (Gap=9) or (Gap=10) then Gap:=11;
    for I:=1 to N-Gap do if Data[I]>Data[I+Gap] then
      begin T:=Data[I]; Data[I]:=Data[I+Gap]; Data[I+Gap]:=T; Flag:=1; end;
  until (Flag=0) and (Gap=1);
end;

const St:array[1..4] of string[5]=('Quick',' Heap',' Comb','Shell');
var I,L:longint;
begin
  Writeln; Writeln('Sorting 5000 long-integers...');
  for I:=1 to 4 do begin
    for L:=1 to 5000 do Data[L]:=Random(5000);
    L:=MemL[0:$46C];
    case I of
      1:QuickSort(1,5000);
      2:HeapSort(5000);
      3:CombSort(5000);
      4:ShellSort(5000);
    end;
    Writeln(St[I],MemL[0:$46C]-L:5,' 1/18.2sec');
  end;
end.
