        public scrollup
        .model small, C
        .CODE
comment|
Routine to scroll an 80 by 25 screen up one row, and color in the new
bottom row with the desired color. Simple starts at offset 160, and
starts moving memory down by 160 bytes until it reaches the bottom of
the screen. Then it writes out all 20h to the bottom row in the desired
color passed to the routine.
|

scrollup proc uses ES DS DI SI, color:byte
	MOV	CX,1920		; Number of character/attribs in 24 rows
	MOV	AX,0B800h	; Color screen offset
	XOR	DI,DI		; Zero DI to point to upper left of screen
	MOV	ES,AX		; Set ES to color screen offset in AX
	MOV	SI,160		; Set SI to beginning of second line
	MOV	DS,AX		; Set DS to color screen offset in AX
	REP	MOVSW		; Move all the characters up one line
	MOV	CX,80		; Number of characters in one line
	MOV	AL,20h		; Character to write to bottom line
	MOV	AH,color	; Color attribute to write
	REP	STOSW		; Write out bottome line
	RET			; Leave!
scrollup endp
        END
