;The following library should be combined with XLIBB.LIB using the Borland
;TLIB utility.

               MASM51                        ;Enforce MASM 5.1 compatibility
               QUIRKS                        ;Allow MASM 5.1 quirks
               NOSMART                       ;No optimization on MASM 5.1

PUSHW          MACRO IMMEDIATE16             ;Macro to PUSH 16-bit constant
               IF (@WordSize EQ 4)
               DB             66H
               ENDIF
               DB             68H
               DW             IMMEDIATE16
               ENDM

PUSHD          MACRO IMMEDIATE32             ;Macro to PUSH 32-bit constant
               IF (@WordSize EQ 2)
               DB             66H
               ENDIF
               DB             68H
               DD             IMMEDIATE32
               ENDM

               .MODEL         LARGE,PASCAL
               .386P
               .387

               INCLUDE        XLIBB.INC

CSEG           SEGMENT PARA PUBLIC USE16 'CODE'
               ASSUME CS:CSEG, DS:DSEG

;Function to calculate linear address from segment address on stack.  Returns
;linear address in DX:AX.
LINADR         PROC FAR, SEGADR:DWORD
               XOR            EAX,EAX        ;Clear high words
               XOR            EDX,EDX
               MOV            AX,WORD PTR SEGADR[0]
               MOV            DX,WORD PTR SEGADR[2]
               SHL            EDX,4          ;Calculate linear address
               ADD            EDX,EAX
               MOV            AX,DX
               SHR            EDX,16         ;Return linear address in DX:AX
               RET
LINADR         ENDP

;Structure defining control block for SUMARRAY.
ARRAYDATA      STRUC
  CONDCODE     DD             0              ;Condition code
  N            DD             0              ;Number of elements to sum
  ADDRESS      DD             0              ;Address of first element
  SUM          DD             0              ;Sum of array elements
ARRAYDATA      ENDS

;Real-mode interface to SUMARRAY32.  Segment address of control block having
;structure ARRAYDATA should be on the stack.
SUMARRAY       PROC FAR, CBSEGADR:DWORD
               PUSH           DS
               PUSHW          DSEG
               POP            DS
               XOR            EAX,EAX        ;Clear high words
               XOR            EDX,EDX
               MOV            AX,WORD PTR CBSEGADR[2]
               MOV            DX,WORD PTR CBSEGADR[0]
               SHL            EAX,4          ;Calculate linear address
               ADD            EAX,EDX
               MOV            CCODEPTR,EAX   ;Reset condition code address
               POP            DS             ;Pop calling DS
               PUSHD          <OFFSET SUMARRAY32>
               CALL           ENTERPM        ;Execute SUMARRAY32 in protected
               RET
SUMARRAY       ENDP

CSEG           ENDS

TSEG           SEGMENT PARA PUBLIC USE32 'CODE'
               ASSUME CS:TSEG, SS:TSEG, DS:TSEG, ES:TSEG, FS:DSEG, GS:DGROUP

;Sum the elements of a single precision array.  Array parameters are stored
;in a control block having structure of ARRAYDATA.  The linear address of the
;control block is stored at CCODEPTR.  An error code of -1 is returned in the
;condition code of the control block if the number of array elements is zero
;XLIB places an error code in the control block if an FPU exception occurs
;while calculating the sum.  This error code will have the FPU status word in
;the high word and the XLIB FPU error code in the low word.  Observe that this
;routine will be called with DS = FLATDSEL (flat-model data descriptor) and
;FS = DSEGSEL (DSEG data descriptor).
SUMARRAY32     PROC NEAR
               MOV            EBX,FS:CCODEPTR               ;Get control block
               MOV            EDX,[EBX].ADDRESS             ;Get array address
               MOV            ESI,[EBX].N                   ;Get N
               SUB            ESI,1
               JB             NODATA                        ;Error:  N = 0
               FLDZ                                         ;Initialize sum
SUMLOOP:       FADD           DWORD PTR [EDX+4*ESI]
               SUB            ESI,1
               JAE            SUMLOOP
               FSTP           [EBX].SUM                     ;Save sum
               RET
NODATA:        MOV            [EBX].CONDCODE,-1             ;Record error code
               RET
SUMARRAY32     ENDP

TSEG           ENDS
               END
