;This file contains the MASM source code for EASYX.LIB.  This code was 
;assembled and then linked with XLIB.LIB to obtain EASYX.LIB.  The source 
;code is included in the XLIB archive primarily as a demonstration of the 
;usage of XLIB.

               .MODEL         LARGE,PASCAL
               .386P

               INCLUDE        XLIB.INC

CSEG           SEGMENT PARA PUBLIC USE16 'CODE'
               ASSUME CS:CSEG

;Allocate extended memory block.  Error code returned in DX:AX.
XMALLOC        PROC FAR,
               NOBYTES:DWORD,                ;Number of bytes to allocate
               ADRPTR:DWORD,                 ;Far pointer to linear address of allocated block
               SIZEPTR:DWORD,                ;Far pointer to size of allocated block
               HANDLEPTR:DWORD               ;Far pointer to handle of allocated block
               PUSH           EBX
               PUSH           ECX
               PUSH           DS
               MOV            EAX,NOBYTES
               CALL           GETMEM
               OR             EAX,EAX
               JNZ            SHORT EXIT
               PUSH           EBX
               LDS            BX,ADRPTR
               MOV            [BX],EDX
               LDS            BX,SIZEPTR
               MOV            [BX],ECX
               LDS            BX,HANDLEPTR
               POP            DWORD PTR [BX]
EXIT:          PUSH           EAX                           ;Return error code in DX:AX
               POP            AX
               POP            DX
               POP            DS
               POP            ECX
               POP            EBX
               RET
XMALLOC        ENDP

;Release extended memory block.  Error code returned in DX:AX.
XFREE          PROC FAR,
               HANDLE:DWORD                                 ;Handle to previously allocated block
               MOV            EAX,HANDLE
               CALL           FREEMEM
               PUSH           EAX                           ;Put error code in DX:AX
               POP            AX
               POP            DX
               RET
XFREE          ENDP

;Map physical memory to logical address space.  Error code returned in DX:AX.
MAPIOMEM       PROC FAR,
               PHYSADR:DWORD,                               ;Linear address of physical memory
               BLKSIZE:DWORD,                               ;Size of memory block (in bytes)
               LOGADRPTR:DWORD                              ;Far pointer to DWORD to receive logical address
               PUSH           BX
               PUSH           DS
               MOV            EDX,PHYSADR
               MOV            EAX,BLKSIZE
               PUSHD          OFFSET PMMAPIO
               CALL           CALLPM
               LDS            BX,LOGADRPTR
               MOV            [BX],EDX
               PUSH           EAX                           ;Place error code in DX:AX
               POP            AX
               POP            DX
               POP            DS
               POP            BX
               RET
MAPIOMEM       ENDP

               ALIGN          16
MOVMEM         PROC FAR,
               DESTADR:DWORD,                               ;Destination address
               SOURCEADR:DWORD,                             ;Source address
               NOBYTES:DWORD                                ;Number of bytes to transfer
               PUSH           ECX
               PUSH           ESI
               PUSH           EDI
               MOV            ESI,SOURCEADR
               MOV            EDI,DESTADR
               MOV            ECX,NOBYTES
               PUSHD          OFFSET MOVMEM32
               CALL           CALLPM
               POP            EDI
               POP            ESI
               POP            ECX
               RET
MOVMEM         ENDP

;Calculate linear address from segment address.  Call with segment address on
;stack.  Linear address returned in EAX and in DX:AX.
LINADR         PROC FAR
               XOR            EAX,EAX
               XOR            EDX,EDX
               MOV            DX,[ESP+4]
               MOV            AX,[ESP+6]
               SHL            EAX,4
               ADD            EAX,EDX
               MOV            EDX,EAX
               SHR            EDX,16
               RET            4
LINADR         ENDP

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;Interfaces to XLIB file management routines.  Each of these procedures should
;be called with the segment address of the control block on the stack.
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

;Create file.
XFCREATE       PROC FAR
               PUSHD          OFFSET PMXCREATE
               JMP            CHAINTOPM
XFCREATE       ENDP

;Open file.
XFOPEN         PROC FAR
               PUSHD          OFFSET PMXOPEN
               JMP            CHAINTOPM
XFOPEN         ENDP

;Close file.
XFCLOSE        PROC FAR
               PUSHD          OFFSET PMXCLOSE
               JMP            CHAINTOPM
XFCLOSE        ENDP

;Load file
XFLOAD         PROC FAR
               PUSHD          OFFSET PMXLOAD
               JMP            CHAINTOPM
XFLOAD         ENDP

;Save file.
XFSAVE         PROC FAR
               PUSHD          OFFSET PMXSAVE
               JMP            CHAINTOPM
XFSAVE         ENDP

;Random read file.
XFREAD         PROC FAR
               PUSHD          OFFSET PMXREAD
               JMP            CHAINTOPM
XFREAD         ENDP

;Random write file.
XFWRITE        PROC FAR
               PUSHD          OFFSET PMXWRITE
               JMP            CHAINTOPM
XFWRITE        ENDP

;Transfer control to protected mode after converting segment address of control
;block to linear address in EAX.
CHAINTOPM      PROC FAR
               PUSH           DWORD PTR [ESP+8]             ;PUSH segment address of control block
               CALL           LINADR
               CALL           CALLPM
               RET            4
CHAINTOPM      ENDP

               EXTERNDEF PASCAL XMALLOC:FAR
               EXTERNDEF PASCAL XFREE:FAR
               EXTERNDEF PASCAL MAPIOMEM:FAR
               EXTERNDEF PASCAL LINADR:FAR
               EXTERNDEF PASCAL MOVMEM:FAR
               EXTERNDEF PASCAL XFCREATE:FAR
               EXTERNDEF PASCAL XFOPEN:FAR
               EXTERNDEF PASCAL XFCLOSE:FAR
               EXTERNDEF PASCAL XFLOAD:FAR
               EXTERNDEF PASCAL XFSAVE:FAR
               EXTERNDEF PASCAL XFREAD:FAR
               EXTERNDEF PASCAL XFWRITE:FAR

CSEG           ENDS

TSEG           SEGMENT PARA PUBLIC USE32 'CODE'
               ASSUME CS:TSEG

;Transfer memory.  Call with source address in ESI, destination address in EDI,
;and number of bytes to transfer in ECX.  Does not preserve registers.
               ALIGN          16
MOVMEM32       PROC NEAR
               CMP            EDI,ESI
               JBE            ENTERDN4
               JMP            ENTERUP4
               ALIGN          4
UP4LOOP:       MOV            EAX,[ESI+1*ECX]               ;Destination address is higher than source address
               MOV            [EDI+1*ECX],EAX
ENTERUP4:      SUB            ECX,4
               JAE            UP4LOOP
               ADD            ECX,4
               JNZ            ENTERUP1
               RET
               ALIGN          4
UP1LOOP:       MOV            AL,[ESI+1*ECX]
               MOV            [EDI+1*ECX],AL
ENTERUP1:      DEC            ECX
               JNS            UP1LOOP
               RET
               ALIGN          4
DN4LOOP:       MOV            EAX,[ESI]                     ;Destination address is lower than source address
               MOV            [EDI],EAX
               ADD            ESI,4
               ADD            EDI,4
ENTERDN4:      SUB            ECX,4
               JAE            DN4LOOP
               ADD            ECX,4
               JNZ            ENTERDN1
               RET
               ALIGN          4
DN1LOOP:       MOV            AL,[ESI]
               MOV            [EDI],AL
               INC            ESI
               INC            EDI
ENTERDN1:      DEC            ECX
               JNS            DN1LOOP
               RET
MOVMEM32       ENDP

TSEG           ENDS
               END
