	PUBLIC  set_vgamode,set_textmode,clearscrn,plotpoint,readpoint
	PUBLIC  setvgapalette,set_partial_pal,g_memwrite,g_memread
	PUBLIC  writescreen, writescreen386
	.MODEL  small, C
	.CODE

set_vgamode PROC
	MOV     AX,13h
	INT     10h
	RET
set_vgamode  ENDP

set_textmode PROC
	MOV     AX,3
	INT     10h
	RET
set_textmode ENDP

clearscrn PROC USES ES DI, color:byte
	MOV     AX,0A000h
	MOV     ES,AX
	XOR     DI,DI
	MOV     CX,32000
	MOV     AL, color
	MOV     AH,AL
	REP     STOSW
	RET
clearscrn ENDP

.286
plotpoint proc USES ES, X:word, Y:word, color:byte
	MOV     AX,0A000h
	MOV     ES,AX
	MOV     AX,Y
	MOV     BX,X
	SHL     AX,6
	ADD     BX,AX
	SHL     AX,2
	ADD     BX,AX
	MOV     AL, byte ptr color
	MOV     ES:[BX], AL
	RET
plotpoint ENDP

readpoint PROC USES ES, X:WORD, Y:WORD
	MOV     AX,0A000h
	MOV     ES,AX
	MOV     AX,Y
	MOV     BX,X
	SHL     AX,6
	ADD     BX,AX
	SHL     AX,2
	ADD     BX,AX
	MOV     AL,ES:[BX]
	RET
readpoint ENDP

setvgapalette proc USES ES DI SI, palbuf:WORD
	CLD
	MOV     SI,palbuf
	XOR     BX,BX
	MOV     DX,03DAh

out_loop:
	MOV     DX,03DAh
non_retrace:
	IN      AL,DX
	TEST    AL,08h
	JNZ     non_retrace

retrace:
	IN      AL,DX
	TEST    AL,08h
	JZ      retrace

	MOV     DX,03C8h
	MOV     CX,128

in_loop:
	MOV     AL,BL
	OUT     DX,AL
	INC     DX
	LODSB
	OUT     DX,AL
	LODSB
	OUT     DX,AL
	LODSB
	OUT     DX,AL
	INC     BX
	DEC     DX
	LOOP    in_loop

	CMP     BX,0FEh
	JB      out_loop

	RET
setvgapalette endp

set_partial_pal proc USES ES DI SI, palbuf:WORD, start:WORD, finish:WORD
	CLD
	INC     word ptr finish
	INC     word ptr start
	XOR     CX,CX
	MOV     AX,finish
	MOV     BX,start
	CMP     BX,AX           ;Is the start larger than finish?
	JGE     @@leaving         ;Yes, so return to caller
	SUB     AX,BX           ;AX = Number of colors to set

	CMP     AX,255
	JNE     @@smaller
	INC     AX
@@smaller:
	CMP     AX,128
	JLE     @@start_loop

	SAR     AX,1
	JNC     @@start_loop
	INC     AX

@@start_loop:

	MOV     SI,palbuf
	PUSH    AX
	MOV     AL,3
	MUL     BL
	ADD     SI,AX
	POP     AX
	MOV     DX,03DAh
	MOV     AH,AL

@@out_loop:
	MOV     DX,03DAh

@@non_retrace:
	IN      AL,DX
	TEST    AL,08h
	JNZ     @@non_retrace

@@retrace:
	IN      AL,DX
	TEST    AL,08h
	JZ      @@retrace

	MOV     DX,03C8h
	MOV     CL,AH

@@in_loop:
	MOV     AL,BL
	OUT     DX,AL
	INC     DX
	LODSB
	OUT     DX,AL
	LODSB
	OUT     DX,AL
	LODSB
	OUT     DX,AL
	INC     BX
	DEC     DX
	LOOP    @@in_loop

	CMP     BX,finish
	JB      @@out_loop
@@leaving:
	RET
set_partial_pal endp

g_memwrite proc uses ES SI DI, inbuf:WORD, start:WORD, length:WORD
	MOV     CX,length
	MOV     AX,0A000h
	MOV     SI,inbuf
	MOV     ES,AX
	MOV     DI,start
	REP     MOVSB
	RET
g_memwrite endp

g_memread proc USES ES DS SI DI, outbuf:WORD, start:WORD, length:WORD
	MOV     CX,length
	MOV     AX,DS
	MOV     ES,AX
	MOV     AX,0A000h
	MOV     DI,outbuf
	MOV     DS,AX
	MOV     SI,start
	REP     MOVSB
	RET
g_memread endp

writescreen proc USES ES SI DI, inbuf:WORD
	MOV	SI,inbuf
	XOR	DI,DI
	MOV	AX,0A000h
	MOV	CX,32000
	MOV	ES,AX
	REP	MOVSW
	RET
writescreen endp
.386
writescreen386 proc USES ES SI DI, inbuf:WORD
	MOV	SI,inbuf
	XOR	DI,DI
	MOV	AX,0A000h
	MOV	CX,16000
	MOV	ES,AX
	REP	MOVSD
	RET
writescreen386 endp
.8086
	END
