#include <stdio.h>
#include <dos.h>
#include "vgalib.h"

void rotate_palette(char *p, int start, int end);
void fadeout(void);
void fadeto(char *p, char *fadepattern);
void whiteout(void);
void normal_palette(char *p);

unsigned char pal[PALSIZE];

void main(void)
{
char splash[] = "Digital News Associates Magazine\n"
		"On sale now at your local BBS for free!\n"
		"Intro Coded by: Zephyr\n"
		"Cool graphix by: Zephyr\n"
		"Ideas by: Zephyr\n"
		"Sound routines by: Zephyr\n"
		"Fonts by: Zephyr\n"
		"Zephyr by: Zephyr\n\n";

int i,j,k;	// Looping variables
int x,y;	// Coordinate variables
char newpal[PALSIZE];
char color;
char temp_data[8];
FILE *input;

input = fopen("data","r");

for(i=0; i<PALSIZE; i++) pal[i] = 0;	//Set palette to all black
for(i=0; i<PALSIZE; i++) newpal[i] = 0;	//Set newpal to all black
for(i=0; i<64; i++) pal[3*i+2] = i;	//Set 1st 64 colors to shades of red
for(i=64; i<128; i++) pal[3*i+1] = i-64;//Set 2nd 64 colors to shades of green
for(i=128; i<192; i++) pal[3*i] = i-128;//Set 3rd 64 colors to shades of blue
for(i=0; i<256; i++) newpal[3*i+2] = 63;//Set newpal to all bright blue
normal_palette(pal);			//Make sure palette is clean

set_vgamode();		// Set to VGA mode 13h
setvgapalette(pal);	// Change palette to pal (described above)
getch();

/*--------------------------------------------------------------------
While loop pulls info from file 'data' and writes data to screen.
Data has numbers in triplicate, indicating the x,y, and color of
a particular pixel. Don't leave a carriage return at the end of the
file, or the program crashes!
--------------------------------------------------------------------*/
while(!feof(input))
  {
  fgets(temp_data,6,input);
  x = atoi(temp_data);
  fgets(temp_data,6,input);
  y = atoi(temp_data);
  fgets(temp_data,6,input);
  color = (char)atoi(temp_data);
  plotpoint(x,y,color);
  }

getch();	// Pause for any key

/*---------------------------------------------------------------------
Clears the screen to each of the 256 colors in quick repetition. Should
go very quickly.
---------------------------------------------------------------------*/
for(i=0; i<COLORS; i++)
  {
  clearscrn(i);
  }

clearscrn(0);	// Clear to black

/*----------------------------------------------------------------------
Kinda difficult to follow routine for writing alternating stripes of
shades of each color on the screen. You figure out what I mean. Hard
to figure out until you see the demo. This writes the three colors on
the screen before they start moving.
----------------------------------------------------------------------*/
for(i=0; i<66; i++)
  {
  for(j=0; j<64; j++)
    {
    for(k=0; k<5; k++)
      {
      plotpoint(k+(j*5),i,(char)j);
      plotpoint(319-(k+(j*5)),i+67,(char)j+64);
      plotpoint(k+(j*5),i+134,(char)j+128);
      }
    }
  }

getch();	// Pause for any key

/*-------------------------------------------------------------------
Moves the three color strips across the screen. Neat effect, and easy
to do too!
-------------------------------------------------------------------*/
for(i=0; i<512; i++)
  {
  rotate_palette(pal,1,255);
  setvgapalette(pal);
  }


getch();	// Pause for any key
whiteout();	// Gradually white out whole screen
fadeto(pal,newpal);	// Fade to bright blue
fadeout();	// Fade to black
set_textmode();	// Drop to text mode
puts(splash);	// Write out info
} // End main


/*---------------------------------------------------------------------
Function rotates the palette to down by one color each time it's called.
Keep in mind that it doesn't write the palette, it just rotates the
palette in memory by one, and let's you set it anyway you choose.
---------------------------------------------------------------------*/
void rotate_palette(char *p, int start, int end)
{
char temp[3];
int j;
int finish,begin;

begin = 3*start;
finish = 3*end;

temp[0] = p[begin];
temp[1] = p[begin + 1];
temp[2] = p[begin + 2];

for(j=begin; j<finish+3; j++) p[j] = p[j+3];

p[finish + 2] = temp[2];
p[finish + 1] = temp[1];
p[finish] = temp[0];
} // End rotate_palette


/*-----------------------------------------------------------------------
Fades entire palette down to black slowly. Uses the set_vgapalette function
from the library. There should be little or no snow on your monitor while
doing this. Some crappy cards still have snow..
-----------------------------------------------------------------------*/
void fadeout(void)
{
unsigned int i,j;

for(j=0; j<64; j++)
  {
  for(i=0; i<PALSIZE; i++) if(pal[i] > 0) pal[i]--;
  setvgapalette(pal);
  }

}


/*----------------------------------------------------------------------
Fades entire palette up to bright white. Uses set_vgapalette. Same notes
as above routine(fadeout).
----------------------------------------------------------------------*/
void whiteout(void)
{
int i,j;

for(j=0; j<64; j++)
  {
  for(i=0; i<PALSIZE; i++) if(pal[i] < 63) pal[i]++;
  normal_palette(pal);
  setvgapalette(pal);
  }
}


/*----------------------------------------------------------------------
It can be confusing when the colors in the palette get above 63. The
functions will still write the data to the VGA card, but the results
can be bizarre. This function cuts off the upper two bits of the colors
to make them fit the registers correctly. You don't want to have to use
this function much. Make sure the registers stay within the correct
parameters, and you'll be fine.
----------------------------------------------------------------------*/
void normal_palette(char *p)
{
unsigned int i;
for(i=0; i<PALSIZE; i++)
  {
  p[i] = p[i] & 0x3F;
  }
}


/*---------------------------------------------------------------------
Much more flexible routine than the ones above. This one lets you set
a whole new palette you'd like to slowly fade into. Neat for doing
screen changes, makes them much smoother.
---------------------------------------------------------------------*/
void fadeto(char *p,char *fadepattern)
{
int i,j;
int done=0;
for(i=0; i<COLORS; i++)
  {
  for(j=0; j<PALSIZE; j++)
    {
    if(p[j] < fadepattern[j])
      {
      p[j]++;
      done++;
      }
    if(p[j] > fadepattern[j])
      {
      p[j]--;
      done++;
      }
    }
  if(done == 0) return;
  done = 0;
  setvgapalette(pal);
  }

}