// Demo program for how to do direct screen writes in C. Written by
// Zephyr - 7/29/94

#include <stdio.h>
#include <dos.h>

void set_VGAmode(void);		// My external assembly routine to set VGA
void set_TEXTmode(void);	// External assembly routine to set to TEXT
int plotpoint(int x, int y, char color);	// C routine...plots a pixel
void clearscrn(char color);	// Clears screen to any color - assembly

void main(void)
{
int i;		// Looping variable
int x,y;
char color;
char temp_data[8];
FILE *input;
input = fopen("data","r");

set_VGAmode();	// Set to VGA mode 13h
getch();

while(!feof(input))
  {
  fgets(temp_data,6,input);
  x = atoi(temp_data);
  fgets(temp_data,6,input);
  y = atoi(temp_data);
  fgets(temp_data,6,input);
  color = (char)atoi(temp_data);
  plotpoint(x,y,color);
  }

getch();

for(i=0; i<256; i++)
  {
  clearscrn(i);
  }

getch();
set_TEXTmode();	// Set back to Text mode(3)
puts("Zephyr's dumb demonstration program");
}

int plotpoint(int x, int y, char color)
{
char far *pixel;
if ( (x > 320) || (x < 0) || (y > 200) || (y < 0) ) return 0;
pixel = MK_FP(0xA000,((320 * y) + x));
*pixel = color;
return 1;
}

