/* File: VGA.C
** Description:
**   Miscellaneous VGA functions.
** Copyright:
**   Copyright 1994, David G. Roberts
*/

#include <dos.h>
#include "gamedefs.h"
#include "vga.h"

/* global variables describing screen parameters */
UINT16	GScreenWidth;
UINT16	GScreenHeight;
UINT16	GScreenVirtualWidth;
UINT8	GVGAMode;


/*
	Function: SetVGAReg
    Description:
    	Sets a VGA register, identified by the IndexReg, DataReg, and
        Index parameters to the value specified by the Data parameter.
*/
void SetVGAReg(UINT16 IndexReg, UINT8 Index, UINT16 DataReg, UINT8 Data)
{
	outportb(IndexReg, Index);
    outportb(DataReg, Data);
}

/*
	Function: SetVGAMode
    Description:
    	Uses the video BIOS to set the VGA video mode.
*/
void SetVGAMode(UINT16 Mode)
{
	union REGS regs;

    regs.x.ax = Mode;

    int86(VGA_BIOS_INT, &regs, &regs);
}

/*
	Function: SetMode13h
    Description:
    	Puts the VGA into Mode 13h and sets the global variables
        describing the screen state appropriately.
*/
void SetMode13h(void)
{
	SetVGAMode(0x13);

	GScreenWidth			= MODE13H_WIDTH;
	GScreenHeight			= MODE13H_HEIGHT;
	GScreenVirtualWidth		= MODE13H_WIDTH;
	GVGAMode				= 0x13;
}

/*
	Function: DetectVGA
    Description:
    	Returns TRUE if a VGA is detected, FALSE otherwise.
*/
BOOL DetectVGA(void)
{
	union REGS regs;

    /* try a BIOS call only the VGA understands */
    regs.x.bx = 0xFFFF;
    regs.x.ax = 0x101A;

    int86(VGA_BIOS_INT, &regs, &regs);

    /* if the card didn't understand, it's not a VGA */
    if (regs.x.bx == 0xFFFF) {
    	return FALSE;
    }
    else {
    	return TRUE;
    }
}

