#include <dos.h>
#include "gamedefs.h"
#include "vga.h"

#define VIDEO_MEMORY_SEGMENT (0xA000)
#define MODE_X_HORIZ	(320)
#define MODE_X_VERT		(240)

/*
	Function: PlotModeX
    Description:
    	Plots a pixel in Mode X.
*/
void PlotModeX
	(
    uint16	X,
    uint16	Y,
    uint8	Color
    )
{
	uint8 Plane;
    uint8 PlaneMask;
	uint16 Offset;
	uint8 far * GraphicsBase;

    /* create a far pointer to the base of video memory */
    GraphicsBase = (uint8 far *) MK_FP(VIDEO_MEMORY_SEGMENT,0);

    /* calculate plane and offset of pixel */
    Plane = X % 4;
    Offset = ((MODE_X_HORIZ / 4) * Y) + (X / 4);

    /* plot point */
    PlaneMask = 1 << Plane;
    SetMMR(PlaneMask);
    GraphicsBase[Offset] = Color;
}
