/* File: PALDEMO.C
** Description:
**   Program to demonstrate palette manipulations including fading
**   and rotation.
** Copyright:
**   Copyright 1994, David G. Roberts
*/

#include <alloc.h>
#include <assert.h>
#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include "gamedefs.h"
#include "bitblt.h"
#include "palette.h"
#include "pcx.h"
#include "retrace.h"
#include "setmodex.h"
#include "vga.h"

#define CHASER_BLOCK_LEN 	(16)
#define BLINK_RATE			(10)

/*
	Function: PlotModeX
    Description:
    	Plots a pixel in Mode X.
*/
void PlotModeX
	(
    UINT16	X,
    UINT16	Y,
    UINT8	Color
    )
{
	UINT8 Plane;
    UINT8 PlaneMask;
	UINT16 Offset;
	UINT8 far * GraphicsBase;

    /* create a far pointer to the base of video memory */
    GraphicsBase = (UINT8 far *) MK_FP(VIDEO_MEM_SEGMENT,0);

    /* calculate plane and offset of pixel */
    Plane = X % 4;
    Offset = ((MODEX_WIDTH / 4) * Y) + (X / 4);

    /* plot point */
    PlaneMask = 1 << Plane;
    SetMMR(PlaneMask);
    GraphicsBase[Offset] = Color;
}

int main()
{
	LINEAR_BITMAP far * ShipLB;
    PLANAR_BITMAP far * ShipPB;
    UINT8 StandardPalette[256][3];
    UINT8 WhitePalette[256][3];
    UINT8 BlackPalette[256][3];
    RGB_TUPLE White = {63, 63, 63};
    RGB_TUPLE Black = {0, 0, 0};
    RGB_TUPLE BlinkOff = {42, 0, 0};
    RGB_TUPLE BlinkOn = {63, 21, 21};
    RGB_TUPLE Green;
    int i;
    int On;
    int BlinkCounter;

	/* check for VGA */
    if (!DetectVGA()) {
    	printf("This program requires a VGA.\n");
        return 1;
    }

    /* load bitmap from PCX */
    ShipLB = LoadPCX("ship1.pcx", NULL);
    if (ShipLB == NULL) {
    	printf("Cannot load SHIP1.PCX.\n");
        return 1;
    }

    /* convert bitmap to planar format */
    ShipPB = LinearToPlanar(ShipLB);

    /* put vga into mode X */
    SetModeX();

	/* draw bitmap */
    BltPlanar(ShipPB, 100, 100, 0);

    /* get palette from VGA */
    GetVGAPaletteBlock(StandardPalette, 0, 16);

    /* fade palette to white over 3 second interval */
    FillPaletteBlock(WhitePalette, 0, 16, &White);
    FadePaletteBlock(StandardPalette, WhitePalette, 0, 16, 3000);

    /* fade palette to black */
    FillPaletteBlock(BlackPalette, 0, 16, &Black);
    FadePaletteBlock(WhitePalette, BlackPalette, 0, 16, 750);

    /* wait a couple seconds for effect */
    delay(2000);

    /* fade palette back to normal in one second */
    FadePaletteBlock(BlackPalette, StandardPalette, 0, 16, 1000);

    /* rotate colors */
    for (i = 0; i < 16; i++) {
        delay(500);
    	RotatePaletteBlock(StandardPalette, 0, 16, 1);
        WaitVerticalRetraceStart();
        SetVGAPaletteBlock(StandardPalette, 0, 16);
    }

    /* blink light on bottom of the spaceship and create "chaser */
    /* light" effect. */

    /* zero out the block we'll be working on */
    FillPaletteBlock(StandardPalette, 16, CHASER_BLOCK_LEN, &Black);
    /* draw pixels in different colors from our block across the screen */
    for (i = 0; i < MODEX_WIDTH; i++) {
    	PlotModeX(i, 200, (i % CHASER_BLOCK_LEN) + 16);
    	PlotModeX(i, 201, (i % CHASER_BLOCK_LEN) + 16);
    	PlotModeX(i, 202, (i % CHASER_BLOCK_LEN) + 16);
    }
    /* grab a color from the VGA and stuff it into the first few */
    /* entries of our palette block */
    GetVGAPaletteEntry(2, &Green);
    FillPaletteBlock(StandardPalette, 16, 6, &Green);

    On = 0;
    BlinkCounter = 0;
    while (!kbhit()) {
        WaitVerticalRetraceStart();

        if (BlinkCounter == BLINK_RATE) {
        	if (On) {
        			SetVGAPaletteEntry(4, &BlinkOn);
        	}
        	else {
        		SetVGAPaletteEntry(4, &BlinkOff);
        	}
        	On = !On;
        	BlinkCounter = 0;
        }
        else {
        	BlinkCounter++;
        }

        /* make those "chaser lights" go! */
        SetVGAPaletteBlock(StandardPalette, 16, CHASER_BLOCK_LEN);
        RotatePaletteBlock(StandardPalette, 16, CHASER_BLOCK_LEN, -2);
    }

    /* clean up and exit */
    SetVGAMode(3);

    farfree(ShipPB);
    farfree(ShipLB);

    return 0;
}