/* File: MOUSEDMO.C
** Description:
**   Demonstrates polled mouse programming.
** Copyright:
**   Copyright 1994, David G. Roberts
*/

#include <assert.h>
#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include "gamedefs.h"
#include "mouse.h"

int main(void)
{
	UINT16 Buttons;
    UINT16 x;
    UINT16 y;

	/* check for mouse driver and initialize it if present */
    if (ResetMouse() == 0) {
    	printf("You must have a mouse to run this program.\n");
        return 1;
    }

    /* display the cursor */
    ShowMouseCursor();

    /* do this until the user hits a key */
	while (!kbhit()) {
    	Buttons = PollMouseStatus(&x, &y);
        /* hide cursor while we print so we don't draw over it or scroll */
        HideMouseCursor();
        printf("X:%4d  Y:%4d  LB:%d  CB:%d  RB:%d\n", x, y,
        	(Buttons & LEFT_BUTTON_MASK) != 0,
            (Buttons & CENTER_BUTTON_MASK) != 0,
            (Buttons & RIGHT_BUTTON_MASK) != 0);
        ShowMouseCursor();
        /* wait 100 ms or so */
        delay(100);
	}

    /* eat the character */
    if (getch() == 0) {
		getch();
    }

    /* hide it when we exit so it's not seen */
    HideMouseCursor();

	return 0;
}