/* File: MODEXDMO.C
** Description:
**		Demo program using Mode X or Mode Y.
** Copyright:
**		Copyright 1994, David G. Roberts
*/

#include <assert.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "gamedefs.h"
#include "setmodex.h"
#include "vga.h"

/* constants */
#define TEXT_MODE_NUMBER	(0x03)
#define MODE_XY_HORIZ		(320)
#define MODE_X_VERT			(240)
#define MODE_Y_VERT			(200)
#define PIXELS_PER_BYTE		(4)
#define BYTES_PER_LINE		(320 / PIXELS_PER_BYTE)
#define VIDEO_MEM_SEGMENT	(0xA000)

/*
	Function: PlotUndocMode
    Description:
    	Plots a point in a undoc mode (either X or Y).
*/
void PlotUndocMode(UINT16 X, UINT16 Y, UINT16 Color)
{
	UINT16 Offset;
	UINT8 far * GraphicsBase;
    int PixelNumber;
    UINT8 PixelMask;

    assert(X < MODE_XY_HORIZ);
    assert(Y < MODE_X_VERT); /* still probs if mode Y and >= MODE_Y_VERT */

	/* compute VGA memory location */
    GraphicsBase = (UINT8 far *) MK_FP(VIDEO_MEM_SEGMENT, 0);
    Offset = Y * BYTES_PER_LINE + (X / PIXELS_PER_BYTE);
	PixelNumber = X % PIXELS_PER_BYTE;

    /* set MMR to enable correct pixel location */
    PixelMask = 1 << PixelNumber;
    SetMMR(PixelMask);

    /* write color to VGA memory location */
    GraphicsBase[Offset] = Color;

    /* clean up */
    SetMMR(0x0F);	/* all pixels */
}

int main(int argc, char *argv[])
{
	int X;
    int Y;
    UINT8 Color;
    char PlotMode;
    int DummyKey;

    /* check for VGA */
    if (!DetectVGA()) {
    	printf("You must have a VGA to run this program.\n");
        return 1;
    }

    /* see if we have a command line parameter.  If not, exit */
    if (argc < 2) {
    	printf("You must supply a graphics mode on the command line.\n");
        return 1;
    }

	/* get mode from command line */
    PlotMode = tolower(argv[1][0]);
    printf("**%s**\n", argv[1]);

    /* make sure people know what format to use */
    if (PlotMode != 'x' && PlotMode != 'y') {
    	printf("Mode must equal 'x' or 'y'.");
    	return 1;
    }

    /* initialize mode */
    if (PlotMode == 'x') {
    	SetModeX();
    }
    else {
    	SetModeY();
    }

    /* seed random number generator */
    randomize();

    /* do polling loop. When key is hit, exit */
    while (!kbhit()) {
		X = random(MODE_XY_HORIZ);
        if (PlotMode == 'x') {
        	Y = random(MODE_X_VERT);
        }
        else {
        	Y = random(MODE_Y_VERT);
        }
        Color = random(256);

        PlotUndocMode(X, Y, Color);
    }

    /* read this so it isn't left hanging around for DOS to find */
    DummyKey = getch();

    /* enter text mode again */
    SetVGAMode(TEXT_MODE_NUMBER);

    /* terminate program */
    return 0;
}
