/* File: INPUTDEV.C
** Description:
**   Example of how to use keyboard, mouse, and joystick function
**   libraries.
** Author:
**   Dave Roberts
**   Copyright 1994, David G. Roberts
*/

#include <dos.h>
#include <stdio.h>
#include "gamedefs.h"
#include "keyboard.h"
#include "jstick.h"
#include "mouse.h"


int main(void)
{
	int KeyState;
    JOYSTICK_STATE JsState;
    int MousePresent;
    UINT16 MouseX;
    UINT16 MouseY;
    UINT16 MouseButtonStatus;
    int MouseLeftButtonState;

    /* figure out if there are any joysticks present, and if so, */
    /* which axes are present. */
	SenseJoysticks(&JsState);

    /* figure out if a mouse is present, and if so, reset it */
    MousePresent = (ResetMouse() > 0);
    ShowMouseCursor();

	SetButtonKeysMode();

	do {

    	/* delay a bit so things don't scroll too fast */
		delay(75);

        /* hide the mouse cursor so that we don't print over it */
        /* or scroll the screen when it's visible */
        HideMouseCursor();

        /* check the state of the Space and Enter keys */
		KeyState = GetKeyState(KEY_SPACE);
		if (KeyState) {
			printf("SPACE D  |  ");
        }
		else {
			printf("SPACE U  |  ");
        }

        KeyState = GetKeyState(KEY_ENTER);
        if (KeyState) {
        	printf("ENTER D  |  ");
        }
        else {
        	printf("ENTER U  |  ");
        }

        /* if a joystick is present (assume joystick A), */
        /* read its state */
        if ((JsState.JsMask & 0x3) != 0) {
			ReadJoysticks(&JsState);
			printf("AX:%4x AY:%4x BA1:%d BA2:%d  |  ",
				JsState.JsAxisAX,
				JsState.JsAxisAY,
    		    JsState.JsButtonA1,
			    JsState.JsButtonA2);
        }

        /* if a mouse is present, read its state */
        if (MousePresent) {
        	MouseButtonStatus = PollMouseStatus(&MouseX, &MouseY);
            MouseLeftButtonState =
				(MouseButtonStatus & LEFT_BUTTON_MASK) != 0;
            printf("MX:%4x MY:%4x MLB:%d",
				MouseX,
                MouseY,
                MouseLeftButtonState);
        }

        printf("\n");
        ShowMouseCursor();

        /* check if Esc is pressed--if so, exit loop */
		KeyState = GetKeyState(KEY_ESC);
	} while (!KeyState);

    /* clean up */
	SetNormalKeysMode();
    HideMouseCursor();

	return 0;
}
