/* File: FLIPDEMO.C
** Description:
**   Demonstrates page flipping.
** Copyright:
**   Copyright 1994, David G. Roberts
*/

#include <alloc.h>
#include <assert.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include "gamedefs.h"
#include "vga.h"
#include "bitblt.h"
#include "retrace.h"
#include "setmodex.h"
#include "animate.h"

UINT8 BallBitmap[] = {
	10, 0,			/* Width (little endian) */
    10, 0,			/* Height (little endian) */
    0, 0,			/* X and Y origin */
    0, 0,
    0, 0, 0, 2, 2, 2, 2, 0, 0, 0, /* color 2 = green w/ default palette */
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 2, 2, 0, 0, 2, 2, 2, 2, 0,
    2, 2, 0, 0, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 0, 2, 2, 2, 2, 0, 0, 0
};

UINT8 BallEraseBitmap[] = {
	10,  0,			/* Width (little endian) */
    10,  0,			/* Height (little endian) */
    0, 0,			/* X and Y origin */
    0, 0,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, /* color 16 = black */
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, /* with default palette */
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16
};

/* note: make these track width and height of bitmap, above */
#define BITMAP_HEIGHT	(10)
#define BITMAP_WIDTH	(10)

#define PAGE0_OFFSET	(0)
#define PAGE1_OFFSET	(0x4B00)

#define NUM_BALLS		(50)

int main()
{
	int x[NUM_BALLS], y[NUM_BALLS];
    int OldX[NUM_BALLS][2], OldY[NUM_BALLS][2];
    int vx[NUM_BALLS], vy[NUM_BALLS];
    int HiddenPage;
    UINT16 Offset[2];
    PLANAR_BITMAP far * PlanarBallBitmap;
    PLANAR_BITMAP far * PlanarBallEraseBitmap;
    BOOL Erase[NUM_BALLS][2];
    int i;

    /* detect VGA */
    if (!DetectVGA()) {
    	printf("You must have a VGA to run this program.\n");
        return 1;
    }

    Offset[0] = PAGE0_OFFSET;
    Offset[1] = PAGE1_OFFSET;

    PlanarBallBitmap = LinearToPlanar((LINEAR_BITMAP far *) BallBitmap);
    PlanarBallEraseBitmap =
		LinearToPlanar((LINEAR_BITMAP far *) BallEraseBitmap);

    /* set Mode X and display page 0 */
    SetModeX();

    for (i = 0; i < NUM_BALLS; i++) {
    	x[i] = random(MODEX_WIDTH - BITMAP_WIDTH);
    	y[i] = random(MODEX_HEIGHT - BITMAP_HEIGHT);
    	vx[i] = random(2) + 1;
    	vy[i] = random(2) + 1;
    	Erase[i][0] = Erase[i][1] = FALSE;
    }

    HiddenPage = 1;

    while (!kbhit()) {
        /* update new position */
        for (i = 0; i < NUM_BALLS; i++) {
        	if (Erase[i][HiddenPage]) {
        		x[i] += vx[i];
        		y[i] += vy[i];
        		if ((x[i] < 0) || ((x[i] + BITMAP_WIDTH) >= MODEX_WIDTH)) {
            		vx[i] = -vx[i];
            		x[i] += 2 * vx[i];
        		}
        		if ((y[i] < 0) || ((y[i] + BITMAP_HEIGHT) >= MODEX_HEIGHT)) {
            		vy[i] = -vy[i];
            		y[i] += 2 * vy[i];
        		}
        	}
        }

        /* erase */
        for (i = 0; i < NUM_BALLS; i++) {
        	if (Erase[i][HiddenPage]) {
    			BltPlanar(PlanarBallEraseBitmap,
					OldX[i][HiddenPage], OldY[i][HiddenPage],
					Offset[HiddenPage]);
            }
        }

    	/* draw */
        for (i = 0; i < NUM_BALLS; i++) {
    		BltPlanar(PlanarBallBitmap, x[i], y[i], Offset[HiddenPage]);
        	OldX[i][HiddenPage] = x[i];
        	OldY[i][HiddenPage] = y[i];
        	Erase[i][HiddenPage] = TRUE;
        }

        /* flip page */
        PageFlip(Offset[HiddenPage]);
        HiddenPage ^= 1; /* flip HiddenPage to other state */
    }

    getch();

    farfree(PlanarBallBitmap);
    farfree(PlanarBallEraseBitmap);

    SetVGAMode(0x3);

    return 0;
}
