/* File: BLTDMOX.C
** Description:
**   Demonstration of the planar bitblt routines in Mode X.
** Author:
**   David G. Roberts
** Date:
** Copyright:
**   Copyright 1994, David G. Roberts
*/

#include <alloc.h>
#include <assert.h>
#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include "gamedefs.h"
#include "bitblt.h"
#include "vga.h"
#include "setmodex.h"

UINT8 BallBitmap[] = {
	10, 0,			/* Width (little endian) */
    10, 0,			/* Height (little endian) */
    0, 0,			/* X & Y origin at top left corner */
    0, 0,
    0, 0, 0, 2, 2, 2, 2, 0, 0, 0, /* color 2 = green w/ default palette */
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 2, 2, 0, 0, 2, 2, 2, 2, 0,
    2, 2, 0, 0, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 0, 2, 2, 2, 2, 0, 0, 0
};

/*
	Function: FillPartialScreen
    Description:
    	Fills the first half of the Mode X screen with the color
        specified as a parameter.  The function takes advantage of
        Mode X's ability to write to four pixels at one time by
        enabling all the display planes at once.  This allows
        fast color fills to be done in 1/4 the time normally taken.
*/
void FillPartialScreen(UINT8 Color)
{
	UINT8 far * Screen;
    int i;

    Screen = MK_FP(VIDEO_MEM_SEGMENT, 0);

    SetMMR(0xF);	/* enable all planes */
    for (i = 0; i < ((MODEX_WIDTH / 4) * (MODEX_HEIGHT / 2)); i++) {
    	*Screen++ = Color;
    }
}

int main()
{
	PLANAR_BITMAP far * PlanarBall;

    /* detect VGA */
    if (!DetectVGA()) {
    	printf("You must have a VGA to run this program.\n");
        return 1;
    }

    SetModeX();

    FillPartialScreen(0x1);	/* fill with blue */

    PlanarBall = LinearToPlanar((LINEAR_BITMAP far *) BallBitmap);

    BltPlanar(PlanarBall, 10, 10, 0);
    BltPlanar(PlanarBall, 115, 115, 0);
    BltPlanar(PlanarBall, 200, 200, 0);

    getch();

    farfree(PlanarBall);

    SetVGAMode(0x3);	/* return to text mode */

    return 0;
}

