/* File: JSTICK.H
** Description:
**   Header file for JSTICK.C.  Defines global variables which
**   are updated with the current values of the joystick positions
**   and button states.
*/

#ifndef _JSTICK_H

#include "gamedefs.h"

typedef struct {
	UINT8 JsMask;
	UINT8 JsButtonA1;
	UINT8 JsButtonA2;
	UINT8 JsButtonB1;
	UINT8 JsButtonB2;
	UINT16 JsAxisAX;
	UINT16 JsAxisAY;
	UINT16 JsAxisBX;
	UINT16 JsAxisBY;
} JOYSTICK_STATE;

void SenseJoysticks(JOYSTICK_STATE * JsState);
void ReadJoysticks(JOYSTICK_STATE * JsState);

#define _JSTICK_H

#endif
