/* File: ISPANDMO.C
** Description:
**   Demonstrates internal sprite animation.  The demo uses the
**   dirty rectangle animation method.
** Copyright:
**   Copyright 1994, David G. Roberts
*/

#include <alloc.h>
#include <assert.h>
#include <conio.h>
#include <dos.h>
#include <mem.h>
#include <stdio.h>
#include <stdlib.h>
#include "gamedefs.h"
#include "vga.h"
#include "bitblt.h"
#include "retrace.h"
#include "animate.h"
#include "pcx.h"

#define BITMAP_HEIGHT	(12)
#define BITMAP_WIDTH	(22)

#define BUFFER_SIZE		(64000)

#define NUM_IMAGES		(4)
#define FRAMES_PER_IMAGE (8)

int main()
{
	int x, y;
    int OldX, OldY;
    int vx, vy;
    BOOL Erase;
    int i;
    UINT8 far * VirtualScreenBuffer;
    RECT DirtyRects[2];
    int Top, Left, Bottom, Right;
    LINEAR_BITMAP far * ShipBitmap[4];
    LINEAR_BITMAP far * ShipEraseBitmap;
    UINT8 far * EraseBitmapData;
    unsigned SpriteImage;
    unsigned FramesCounter;

    /* detect VGA */
    if (!DetectVGA()) {
    	printf("You must have a VGA to run this program.\n");
        return 1;
    }

    /* allocate virtual screen buffer */
    VirtualScreenBuffer = (UINT8 far *) farmalloc(BUFFER_SIZE);
    if (VirtualScreenBuffer == NULL) {
    	fprintf(stderr, "Couldn't allocate memory buffer\n");
        exit(1);
    }
    /* clear buffer to 0 to match state of Mode 13h screen */
    _fmemset(VirtualScreenBuffer, 0, BUFFER_SIZE);

    ShipBitmap[0] = LoadPCX("ship1.pcx", NULL);
    if (ShipBitmap[0] == NULL) {
    	printf("Can't load ship bitmap.\n");
        return 1;
    }

    ShipBitmap[1] = LoadPCX("ship2.pcx", NULL);
    if (ShipBitmap[1] == NULL) {
    	printf("Can't load ship bitmap.\n");
        return 1;
    }

    ShipBitmap[2] = LoadPCX("ship3.pcx", NULL);
    if (ShipBitmap[2] == NULL) {
    	printf("Can't load ship bitmap.\n");
        return 1;
    }

    ShipBitmap[3] = LoadPCX("ship4.pcx", NULL);
    if (ShipBitmap[3] == NULL) {
    	printf("Can't load ship bitmap.\n");
        return 1;
    }

    /* create the erase bitmap from a real image with the bits */
    /* changed to be non-transparent black (color 16 in default palette */
    ShipEraseBitmap = LoadPCX("ship1.pcx", NULL);
    if (ShipEraseBitmap == NULL) {
    	printf("Can't load ship bitmap.\n");
        return 1;
    }
    EraseBitmapData = &(ShipEraseBitmap->Data);
    for (i = 0; i < ShipEraseBitmap->Width * ShipEraseBitmap->Height; i++) {
		*EraseBitmapData++ = 16;
    }

    SetMode13h();

	x = y = 0;

    vx = 1;
    vy = 2;

    SpriteImage = 0;
    FramesCounter = 0;

    while (!kbhit()) {

    	if (Erase) {
        	/* update new position */
        	OldX = x;
        	OldY = y;
        	x += vx;
        	y += vy;
        	if ((x < 0) || ((x + BITMAP_WIDTH) >= MODE13H_WIDTH)) {
            	vx = -vx;
            	x += 2 * vx;
        	}
        	if ((y < 0) || ((y + BITMAP_HEIGHT) >= MODE13H_HEIGHT)) {
            	vy = -vy;
            	y += 2 * vy;
        	}
        }

        /* erase */
    	if (Erase) {
    		BltLinear(ShipEraseBitmap, OldX, OldY, VirtualScreenBuffer);

        	DirtyRects[0].Top = OldY - ShipEraseBitmap->OriginY;
            DirtyRects[0].Left = OldX - ShipEraseBitmap->OriginX;
            DirtyRects[0].Bottom = OldY - ShipEraseBitmap->OriginY +
				ShipEraseBitmap->Height;
            DirtyRects[0].Right = OldX - ShipEraseBitmap->OriginX +
				ShipEraseBitmap->Width;

            /* see if it's time to go to the next sprite image */
            FramesCounter++;
            if (FramesCounter >= FRAMES_PER_IMAGE) {
            	FramesCounter = 0;
                /* if so, bump image counter and handle wrap-around */
            	SpriteImage++;
                if (SpriteImage >= NUM_IMAGES) {
                	SpriteImage = 0;
                }
            }
        }

    	/* draw */
    	BltLinear(ShipBitmap[SpriteImage], x, y, VirtualScreenBuffer);

        DirtyRects[1].Top = y - ShipBitmap[SpriteImage]->OriginY;
        DirtyRects[1].Left = x - ShipBitmap[SpriteImage]->OriginX;
        DirtyRects[1].Bottom = y - ShipBitmap[SpriteImage]->OriginY +
			ShipBitmap[SpriteImage]->Height;
        DirtyRects[1].Right = x - ShipBitmap[SpriteImage]->OriginX +
			ShipBitmap[SpriteImage]->Width;

        WaitVerticalRetraceStart();
        CopyRects(DirtyRects, 2, VirtualScreenBuffer);
    }

    getch();

    SetVGAMode(0x3);

    farfree(ShipBitmap[0]);
    farfree(ShipBitmap[1]);
    farfree(ShipBitmap[2]);
    farfree(ShipBitmap[3]);
    farfree(ShipEraseBitmap);
    farfree(VirtualScreenBuffer);

    return 0;
}


