/* File: BITBLT.H
** Description:
**   Header file for BITBLT.C.  Module for bitblt'ing bitmaps to
**   the screen.
** Copyright:
**   Copyright 1994, David G. Roberts
*/

#ifndef _BITBLT_H

#include "gamedefs.h"

typedef struct {
	UINT16 Width;
    UINT16 Height;
    int OriginX;
    int OriginY;
    UINT8 Data;
} LINEAR_BITMAP;

typedef struct {
	UINT16 Width;			/* Bitmap width = actual width divided by 4 */
    UINT16 Height;
    int OriginX;
    int OriginY;
    UINT8 Data;
} PLANAR_BITMAP;

typedef struct {
	UINT16 Width;			/* Width = true width / 4 */
    UINT16 Height;
    int OriginX;
    int OriginY;
    UINT16 VideoDataOffset;	/* offset to image data in video memory */
    UINT8 MapMaskData;
} VIDEO_MEM_BITMAP;

/* exported functions and variables */
void BltLinear(LINEAR_BITMAP far * LinearBM, int x, int y,
	UINT8 far * ScreenBase);
void BltLinearNoTransparent(LINEAR_BITMAP far * LinearBM, int x, int y,
	UINT8 far * ScreenBase);
PLANAR_BITMAP far * LinearToPlanar(LINEAR_BITMAP far * LinearBM);
void BltPlanar(PLANAR_BITMAP far * PlanarBM, int x, int y,
	UINT16 PageOffset);
void BltPlanarNoTransparent(PLANAR_BITMAP far * PlanarBM, int x, int y,
	UINT16 PageOffset);
VIDEO_MEM_BITMAP far * LinearToVideoMemory(LINEAR_BITMAP far * LinearBM,
	UINT16 Storage, UINT16 * Length);
void BltVideoMem(VIDEO_MEM_BITMAP far * VideoBM, int x, int y,
	UINT16 PageOffset);
void BltVideoMemNoTransparent(VIDEO_MEM_BITMAP far * VideoBM, int x, int y,
	UINT16 PageOffset);
void BltLinearClipRect(LINEAR_BITMAP far * LinearBM, int x, int y,
	UINT8 far * ScreenBase, RECT * ClipRect);
void BltPlanarClipRect(PLANAR_BITMAP far * PlanarBM, int x, int y,
	UINT16 PageOffset, RECT * ClipRect);

#define _BITBLT_H

#endif
