/* File: VSCNDEMO.C
** Description:
**   Demonstrates the virtual screen buffer animation technique.
** Copyright:
**   Copyright 1994, David G. Roberts
*/

#include <alloc.h>
#include <assert.h>
#include <conio.h>
#include <dos.h>
#include <mem.h>
#include <stdio.h>
#include <stdlib.h>
#include "gamedefs.h"
#include "vga.h"
#include "bitblt.h"
#include "retrace.h"
#include "animate.h"

UINT8 BallBitmap[] = {
	10, 0,			/* Width (little endian) */
    10, 0,			/* Height (little endian) */
    0, 0,			/* X and Y origin */
    0, 0,
    0, 0, 0, 2, 2, 2, 2, 0, 0, 0, /* color 2 = green w/ default palette */
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 2, 2, 0, 0, 2, 2, 2, 2, 0,
    2, 2, 0, 0, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 0, 2, 2, 2, 2, 0, 0, 0
};

UINT8 BallEraseBitmap[] = {
	10,  0,			/* Width (little endian) */
    10,  0,			/* Height (little endian) */
    0, 0,			/* X and Y origin */
    0, 0,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, /* color 16 = black */
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, /* with default palette */
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16
};

/* note: make these track width and height of bitmap, above */
#define BITMAP_HEIGHT	(10)
#define BITMAP_WIDTH	(10)

#define NUM_BALLS		(50)

#define BUFFER_SIZE		(64000)

int main()
{
	int x[NUM_BALLS], y[NUM_BALLS];
    int OldX[NUM_BALLS], OldY[NUM_BALLS];
    int vx[NUM_BALLS], vy[NUM_BALLS];
    BOOL Erase[NUM_BALLS];
    int i;
    UINT8 far * VirtualScreenBuffer;

    /* detect VGA */
    if (!DetectVGA()) {
    	printf("You must have a VGA to run this program.\n");
        return 1;
    }

    for (i = 0; i < NUM_BALLS; i++) {
    	x[i] = random(MODE13H_WIDTH - BITMAP_WIDTH);
    	y[i] = random(MODE13H_HEIGHT - BITMAP_HEIGHT);
    	vx[i] = random(2) + 1;
    	vy[i] = random(2) + 1;
    	Erase[i] = FALSE;
    }

    /* allocate virtual screen buffer */
    VirtualScreenBuffer = (UINT8 far *) farmalloc(BUFFER_SIZE);
    if (VirtualScreenBuffer == NULL) {
    	fprintf(stderr, "Couldn't allocate memory buffer\n");
        exit(1);
    }
    /* clear buffer to 0 to match state of Mode 13h screen */
    _fmemset(VirtualScreenBuffer, 0, BUFFER_SIZE);

    SetMode13h();

    while (!kbhit()) {
    	for (i = 0; i < NUM_BALLS; i++) {
    		if (Erase[i]) {
        		/* update new position */
        		OldX[i] = x[i];
        		OldY[i] = y[i];
        		x[i] += vx[i];
        		y[i] += vy[i];
        		if ((x[i] < 0) || ((x[i] + BITMAP_WIDTH) >= MODE13H_WIDTH)) {
            		vx[i] = -vx[i];
            		x[i] += 2 * vx[i];
        		}
        		if ((y[i] < 0) || ((y[i] + BITMAP_HEIGHT) >= MODE13H_HEIGHT)) {
            		vy[i] = -vy[i];
            		y[i] += 2 * vy[i];
        		}
            }
        }

        /* erase */
    	for (i = 0; i < NUM_BALLS; i++) {
    		if (Erase[i]) {
    			BltLinear((LINEAR_BITMAP far *) BallEraseBitmap,
					OldX[i], OldY[i], VirtualScreenBuffer);
        	}
        }

    	/* draw */
    	for (i = 0; i < NUM_BALLS; i++) {
    		BltLinear((LINEAR_BITMAP far *) BallBitmap, x[i], y[i],
				VirtualScreenBuffer);
        	Erase[i] = TRUE;
        }

		_fmemcpy(MK_FP(VIDEO_MEM_SEGMENT,0), VirtualScreenBuffer,
			BUFFER_SIZE);
    }

    getch();

    SetVGAMode(0x3);

    return 0;
}


