/* File: PALETTE.H
** Description:
**   Header file for PALETTE.C, which includes routines for manipulating
**   the VGA palette.
** Copyright:
**   Copyright 1994, David G. Roberts
*/

#ifndef _PALETTE_H

#include "gamedefs.h"

typedef struct {
	UINT8 r;
	UINT8 g;
	UINT8 b;
} RGB_TUPLE;

void SetVGAPaletteEntry(int Index, RGB_TUPLE * Rgb);
void GetVGAPaletteEntry(int Index, RGB_TUPLE * Rgb);
void SetVGAPaletteBlock(UINT8 Palette[256][3], int Start, int Length);
void GetVGAPaletteBlock(UINT8 Palette[256][3], int Start, int Length);
void SetPaletteEntry(UINT8 Palette[256][3], int Index, RGB_TUPLE * Rgb);
void GetPaletteEntry(UINT8 Palette[256][3], int Index, RGB_TUPLE * Rgb);
void FillPaletteBlock(UINT8 Palette[256][3], int Start, int Length,
	RGB_TUPLE * Rgb);
void CopyPaletteBlock(UINT8 DestPalette[256][3],
	UINT8 SourcePalette[256][3], int Start, int Length);
void ComputeFadeStep(UINT8 StartPalette[256][3], UINT8 EndPalette[256][3],
	int Start, int Length, long NumSteps, long CurrentStep,
	UINT8 FadeStepPalette[256][3]);
void FadePaletteBlock(UINT8 StartPalette[256][3],
	UINT8 EndPalette[256][3], int Start, int Length, int Milliseconds);
void RotatePaletteBlock(UINT8 Palette[256][3], int Start, int Length,
	int Rotation);

#define _PALETTE_H

#endif
