/* File: BLTDMO13.C
** Description:
**   Demonstrates Mode 13h linear bitmaps.  Fills half the screen
**   with red pixels and draws a ball bitmap several times to show
**   the effect of transparent pixels and clipping.
** Copyright:
**   Copyright 1994, David G. Roberts
*/

#include <assert.h>
#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include "gamedefs.h"
#include "vga.h"
#include "bitblt.h"

UINT8 BallBitmap[] = {
	10, 0,			/* Width (little endian) */
    10, 0,			/* Height (little endian) */
    0, 0,			/* X & Y origin at top left corner */
    0, 0,
    0, 0, 0, 2, 2, 2, 2, 0, 0, 0, /* color 2 = green w/ default palette */
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 2, 2, 0, 0, 2, 2, 2, 2, 0,
    2, 2, 0, 0, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 0, 2, 2, 2, 2, 0, 0, 0
};

void FillPartialScreen(UINT8 Color)
{
	UINT8 far * Screen;
    int i;

    Screen = MK_FP(VIDEO_MEM_SEGMENT, 0);

    for (i = 0; i < (MODE13H_WIDTH * (MODE13H_HEIGHT / 2)); i++) {
    	*Screen++ = Color;
    }
}

int main()
{
    /* detect VGA */
    if (!DetectVGA()) {
    	printf("You must have a VGA to run this program.\n");
        return 1;
    }

    SetMode13h();

    FillPartialScreen(0x04); /* 4 = red in default palette */

    BltLinear((LINEAR_BITMAP far *) &BallBitmap, 10, 10,
		(UINT8 far *) MK_FP(VIDEO_MEM_SEGMENT,0));
    BltLinear((LINEAR_BITMAP far *) &BallBitmap, 95, 95,
		(UINT8 far *) MK_FP(VIDEO_MEM_SEGMENT,0));
    BltLinear((LINEAR_BITMAP far *) &BallBitmap, 120, 120,
		(UINT8 far *) MK_FP(VIDEO_MEM_SEGMENT,0));

    getch();

    SetVGAMode(0x3);	/* return to text mode */

    return 0;
}

