/* File: ANIDEMO3.C
** Description:
**   Demonstrates problems when you try to draw a lot of sprites during
**   vertical retrace.
** Copyright:
**   Copyright 1994, David G. Roberts
*/

#include <assert.h>
#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include "gamedefs.h"
#include "vga.h"
#include "bitblt.h"
#include "retrace.h"

UINT8 BallBitmap[] = {
	10, 0,			/* Width (little endian) */
    10, 0,			/* Height (little endian) */
    0, 0,			/* X and Y origin */
    0, 0,
    0, 0, 0, 2, 2, 2, 2, 0, 0, 0, /* color 2 = green w/ default palette */
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 2, 2, 0, 0, 2, 2, 2, 2, 0,
    2, 2, 0, 0, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 0, 2, 2, 2, 2, 0, 0, 0
};

UINT8 BallEraseBitmap[] = {
	10,  0,			/* Width (little endian) */
    10,  0,			/* Height (little endian) */
    0, 0,			/* X and Y origin */
    0, 0,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, /* color 16 = black */
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, /* with default palette */
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16
};

/* note: make these track width and height of bitmap, above */
#define BITMAP_HEIGHT	(10)
#define BITMAP_WIDTH	(10)

#define NUM_BALLS		(50)

int main()
{
	int x[NUM_BALLS], y[NUM_BALLS];
    int OldX[NUM_BALLS], OldY[NUM_BALLS];
    int vx[NUM_BALLS], vy[NUM_BALLS];
    BOOL Erase[NUM_BALLS];
    int i;

    /* detect VGA */
    if (!DetectVGA()) {
    	printf("You must have a VGA to run this program.\n");
        return 1;
    }

    SetMode13h();

    for (i = 0; i < NUM_BALLS; i++) {
    	x[i] = random(MODE13H_WIDTH - BITMAP_WIDTH);
    	y[i] = random(MODE13H_HEIGHT - BITMAP_HEIGHT);
    	vx[i] = random(2) + 1;
    	vy[i] = random(2) + 1;
    	Erase[i] = FALSE;
    }

    while (!kbhit()) {
    	for (i = 0; i < NUM_BALLS; i++) {
    		if (Erase[i]) {
        		/* update new position */
        		OldX[i] = x[i];
        		OldY[i] = y[i];
        		x[i] += vx[i];
        		y[i] += vy[i];
        		if ((x[i] < 0) || ((x[i] + BITMAP_WIDTH) >= MODE13H_WIDTH)) {
            		vx[i] = -vx[i];
            		x[i] += 2 * vx[i];
        		}
        		if ((y[i] < 0) || ((y[i] + BITMAP_HEIGHT) >= MODE13H_HEIGHT)) {
            		vy[i] = -vy[i];
            		y[i] += 2 * vy[i];
        		}
            }
        }

	    /* wait for vertical retrace before we erase and draw */
	    WaitVerticalRetraceStart();

        /* erase */
    	for (i = 0; i < NUM_BALLS; i++) {
    		if (Erase[i]) {
    			BltLinear((LINEAR_BITMAP far *) BallEraseBitmap,
					OldX[i], OldY[i], MK_FP(VIDEO_MEM_SEGMENT, 0x0000));
        	}
        }

    	/* draw */
    	for (i = 0; i < NUM_BALLS; i++) {
    		BltLinear((LINEAR_BITMAP far *) BallBitmap, x[i], y[i],
				MK_FP(VIDEO_MEM_SEGMENT, 0x0000));
        	Erase[i] = TRUE;
        }
    }

    getch();

    SetVGAMode(0x3);

    return 0;
}


