/* File: ANIDEMO1.C
** Description:
**   Simple animation demonstration.
** Copyright:
**   Copyright 1994, David G. Roberts
*/

#include <assert.h>
#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include "gamedefs.h"
#include "vga.h"
#include "bitblt.h"

UINT8 BallBitmap[] = {
	10, 0,			/* Width (little endian) */
    10, 0,			/* Height (little endian) */
    0, 0,			/* X and Y origin */
    0, 0,
    0, 0, 0, 2, 2, 2, 2, 0, 0, 0, /* color 2 = green w/ default palette */
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 2, 2, 0, 0, 2, 2, 2, 2, 0,
    2, 2, 0, 0, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 0, 2, 2, 2, 2, 0, 0, 0
};

UINT8 BallEraseBitmap[] = {
	10,  0,			/* Width (little endian) */
    10,  0,			/* Height (little endian) */
    0, 0,			/* X and Y origin */
    0, 0,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, /* color 16 = black */
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, /* with default palette */
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16
};

/* note: make these track width and height of bitmap, above */
#define BITMAP_HEIGHT	(10)
#define BITMAP_WIDTH	(10)

int main()
{
	int x, y;
    int OldX, OldY;
    int vx, vy;
    BOOL Erase;

    /* detect VGA */
    if (!DetectVGA()) {
    	printf("You must have a VGA to run this program.\n");
        return 1;
    }

    SetMode13h();

    x = 0;
    y = 0;
    vx = 2;
    vy = 1;

    Erase = FALSE;

    while (!kbhit()) {
    	if (Erase) {
        	/* update new position */
        	OldX = x;
        	OldY = y;
        	x += vx;
        	y += vy;
        	if ((x < 0) || ((x + BITMAP_WIDTH) >= MODE13H_WIDTH)) {
            	vx = -vx;
            	x += 2 * vx;
        	}
        	if ((y < 0) || ((y + BITMAP_HEIGHT) >= MODE13H_HEIGHT)) {
            	vy = -vy;
            	y += 2 * vy;
        	}

        	/* erase */
    		BltLinear((LINEAR_BITMAP far *) BallEraseBitmap, OldX, OldY,
				MK_FP(VIDEO_MEM_SEGMENT, 0x0000));
        }

    	/* draw */
    	BltLinear((LINEAR_BITMAP far *) BallBitmap, x, y,
			MK_FP(VIDEO_MEM_SEGMENT, 0x0000));
        Erase = TRUE;

        /* delay a bit */
        delay(20);

    }

    getch();

    SetVGAMode(0x3);

    return 0;
}


