/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*            This header file was written by Peter Fitzsimmons             */
/*                                                                          */
/*             OS/2 Communications definitions for BinkleyTerm              */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Baud rate masks */

#define BAUD_300		300
#define BAUD_1200		1200
#define BAUD_2400		2400
#define BAUD_4800		4800
#define BAUD_9600		9600
#define BAUD_19200		19200
#define BAUD_38400		38400
#define BAUD_57600		57600
#define BAUD_115200		115200

unsigned Cominit (int, int);
void MDM_DISABLE (void);
void MDM_ENABLE (unsigned long);

typedef unsigned char bool;

extern void com_XON_enable (void);
extern void com_XON_disable (void);
extern void com_DTR_on (void);
extern void com_DTR_off (void);
extern void com_break (int on);
extern int com_getc (int);

extern void MDM_ENABLE (unsigned long rate);
extern void MDM_DISABLE (void);
unsigned Cominit (int port, int failsafe);
extern int get_key (void);
extern USHORT ComTXBlockTimeout (BYTE *lpBuf, USHORT cbBuf, ULONG ulTimer);
extern USHORT ComTXRemain (void);

/* translate binkley fossil stuff to my async package */

#define CARRIER				(ComIsOnline(hcModem))
#define CHAR_AVAIL()		ComInCount(hcModem)
#define OUT_EMPTY()			(ComOutCount(hcModem)==0)
#define OUT_FULL()			(ComOutSpace(hcModem)==0)
#define LOWER_DTR()			com_DTR_off()
#define RAISE_DTR()			com_DTR_on()
#define CLEAR_OUTBOUND()	ComPurge(hcModem, COMM_PURGE_TX)
#define CLEAR_INBOUND()		ComPurge(hcModem, COMM_PURGE_RX)
#define KEYPRESS()			kbhit()
#define READKB()			get_key()
#define FOSSIL_CHAR()		get_key()
#define XON_ENABLE()		com_XON_enable()
#define IN_XON_ENABLE()
#define XON_DISABLE()		com_XON_disable()
#define _BRK_DISABLE()
#define FOSSIL_WATCHDOG(x)
#define SENDBYTE(c)			ComPutc(hcModem, c)
#define BUFFER_BYTE(c)		ComPutc(hcModem, c)
#define UNBUFFER_BYTES()	ComTxWait(hcModem, 1L)	/* yield cpu for a moment*/
#define MODEM_IN()			ComGetc(hcModem)
#define WRITE_ANSI(c)		putch (c)
#define PEEKBYTE()			ComPeek(hcModem)
#define do_break(on)		com_break(on)
#define SENDCHARS(buf, size, carcheck)	ComWrite(hcModem, buf, (USHORT)size)
#define hfComHandle			ComGetFH(hcModem)

#define real_flush(fh)		DosBufReset((HFILE)fh)

/* some useful bits */

#define RLSD	0x80		/* (MSR) Received line signal detect */
							/* sometimes called Carrier Detect */

#define THRE	0x20		/* (LSR) Transmitter holding register empty */
							/* (ready for another byte) */

#define DR		0x1			/* (LSR) Data ready indicator */

#define OE		0x2			/* (LSR) Overrun error! We are not reading */
							/* bytes fast enuf */

void ShowMdmSettings (void);

/* END OF FILE: com_os2.h */

