PUBLIC	bin2asc
	.model	small,C
	.DATA
;None needed, all data kept in registers or declared in accompanying
;C program.
	.CODE

;Procedure sent a character to change in the form of a word and
;the string to put it in. String needs to be at least 8 characters
;long, not including the null terminator. Declaring in C would
;require:
;'char string[9];'
;Keep in mind that C strings are just an array in memory with a null
;character terminator. 


bin2asc	PROC uses SI, changechar:WORD, outstring:WORD
	CLD		;Clear DF so string functions move forward in mem
	PUSH	DS	;Set ES equal to
	POP	ES	;  DS
	MOV	CX,8	;How many characters to output 8, for the 8 bits
	MOV     BX,changechar	;Character to modify to an ASCIIZ string
	MOV	BH,BL	;Put character in BH
	MOV	BL,1	;Put AND filter in BL
	MOV	DI,outstring	;String register...where to write output
@@l:
	MOV	AL,BH	;Put character into AL
	AND	AL,BL	;AND with filter to find if last bit is set or not
	STOSB		;Store it as a 0 or 1 in string at ES:DI
	SHR	BH,1	;Shift character to right to check next bit
	LOOP	@@l	;Loop for 8 times to @@l

	CALL	characters
	CALL	reverse
	RET
bin2asc	ENDP



;Procedure to change the ones and zeros into their ASCII counterparts
characters	PROC
	MOV	SI,outstring	;Set string registers to
	MOV	DI,SI		;  beginning of string
	MOV	CX,8		;8 bits again...
@@l2:
	LODSB		;Load character into AL
	CMP	AL,0	;Check if zero
	JE	@@h	;If so, go to @@h
	MOV	AL,49	;  Otherwise, set to ASCII one and
	STOSB		;  print it to string
@@l3:
	LOOP	@@l2	;Loop back to @@2 for next bit
	JMP	short @@end	;Jump to end of procedure when done
@@h:
	MOV	AL,48	;bit was a one, so set to ASCII one
	STOSB		; and print to string
	JMP	short @@l3	;Jump back into the loop for next bit
@@end:
	RET		;Return to caller
characters	ENDP



;Procedure to reverse order of string
reverse	PROC
	MOV	SI,outstring	;Set string registers to point
	MOV	DI,SI		;  to reversing string
	MOV	CX,4		;do 4 times, using lodsw, which loads
				;  whole words instead of bytes
@@l4:
	LODSW			;Load word into AX...first 2 bytes of string
	XCHG	AL,AH		;change their order and
	PUSH	AX		;  push onto stack
	LOOP	@@l4		;Loop until done with 8 character string
	
	MOV	CX,4		;Once again...do 4 times
	MOV	SI,outstring	;Load string registers with beginning
	MOV	DI,SI		;  of string

@@l5:
	POP	AX		;Pop each word off the stack and
	STOSW			;  write to string
	LOOP	@@l5		;Do until all 4 words written

	RET			;Return to caller
reverse	ENDP
	END			;DONE