/* Program to go with test.asm. Outputs the binary scan codes for all of
the 256 ASCII characters. Easily modified to show more digits if need be.
Written for Turbo C++. Compile with:
'tcc t.c test.asm'
or if you want to watch it in the turbo debugger:
'tcc -v t.c test.asm'
Once compiled, if you want to save the info to disk, just type:
't > FILE'
where FILE is the file you want to output the data to.

Zephyr
*/

#include <stdio.h>

void bin2asc(int changechar, char *outstring);

/*External assembly routine which takes a byte as input and transforms
  it into an ASCIIZ string at the pointer 'outstring'.*/

int main(void)
{
 int i=0; /*Counter integer...used in the for loop*/
 char outstring[9]; /*8 char string with null terminator in last byte*/

 printf("Scan codes: \n");

 for(i=0;i<=255;i++) /*Do for all 256 characters...value 0 to 255*/
 {
  bin2asc(i,&outstring); /*Call external procedure*/
  printf("%d--%c-- %s \n",i,i,outstring);
  /*Above statement prints each character as it's decimal equivalent
    and it's character representation, then in binary.*/
 }

return 0; /*Exit to DOS...errorlevel 0*/
}
