;	     32BIT  DOS  EXTENDER
;
; Written by Adam Seychell 	Wed 8-25-1993
;
.386


CODE32	SEGMENT PARA PUBLIC  USE32
assume	DS:CODE32 , CS:CODE32
extrn	CODE32_sel	:word		; Selector Values
extrn	DATA_sel	:word
extrn	VIDEO_sel	:word
extrn	FLAT_CODE32_sel	:word
extrn	FLAT_DATA_sel	:word
extrn	XMS_sel		:word
extrn	BASE_sel	:word
extrn	PSP_sel		:word
extrn	ENVIRONMENT_sel	:word

align 4
xms_usage	dd 0		; Requested size of XMS block in bytes.
xms_base	dd ?		; Linear base address of the XMS block.
Base_Segment	dw ?		; Real mode segment value for base memory.
PSP_segment	dw ?		; Real mode segment value for PSP segment.

include		dos32.inc

start32:		; 32 bit code entry point.


        mov	ds,cs:[data_sel]       ;Must load these with valid selectors
	mov	es,cs:[data_sel]
	mov	fs,CS:[FLAT_DATA_sel]
	mov	gs,CS:[XMS_sel]
        mov	ss,CS:[data_sel]		; Must set a stack area
	mov	esp,offset pmode_stack
        mov	[real_DS],CODE32		; Set the DS reg for V86 mode
	sti


		; Example to call a real mode interrupt

        mov 	dx,offset v86_mesg
	mov	ah,9
        dosint	21h

	mov ah,4ch		; Termiate the program
        int 21h


v86_mesg   db ' Message printed in v86 mode ',10,13,36

; The 16 hardware inetrrupts.
; If an IRQ accours in V86 mode the segment registers will contain same
; selector values as they were before the last V86 call. ( i.e dosint xx ).
IRQ0:	dosint 08h                      ;  8253  Timer 0
	iretd
IRQ1:	dosint 09h			;  8242 Keyboard
	iretd
IRQ2:	dosint 0Ah                      ; LPT 2 or  Vert Retrate (6845)
	iretd
IRQ3:	dosint 0Bh			; Serial communications ports 2 & 4
	iretd
IRQ4:	dosint 0Ch			; Serial communications ports 1 & 3
	iretd
IRQ5:	dosint 0Dh			; Reserved
	iretd
IRQ6:	dosint 0Eh			; NEC PD765 Floppy Disk Controler
	iretd
IRQ7:	dosint 0Fh                      ; LPT 1
	iretd
IRQ8:	dosint 70h			; 6818 CMOS CLOCK
	iretd
IRQ9:	dosint 71h			; Reserved
	iretd
IRQ10:	dosint 72h			; Reserved
	iretd
IRQ11:	dosint 73h			; Reserved
	iretd
IRQ12:	dosint 74h			; Reserved
	iretd
IRQ13:	dosint 75h			; 80x87 Math Co-Pro exception.
	iretd
IRQ14:	dosint 76h			; Hard Drive Cotroller.
	iretd
IRQ15:	dosint 77h			; Reserved
	iretd

align 4
db 100h dup (?)
pmode_stack:

CODE32 ENDS

END