/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

nihilist::nihilist(){
  *cipher = (char) NULL;
  ocipher = NULL;
  clen = 0;
  length = 0;
  period = 0;
  period_set = FALSE;
}

int nihilist::execute_option(char option){
  int valid = TRUE;

  switch(option){
    case MOVE:
      move_stuff();
      break;
    case UNDO:
      undo();
      vert2horiz();
      break;
    default:
      valid = base_exec_option(option);
      break;
  }

  return valid;
}

int nihilist::set_period(int newperiod){
  int i;

  if(period_set == FALSE || newperiod){
    period = newperiod;
    if(!period){
      for(i = 0; i*i <= length; i++){
	if(i*i == length){
	  period = i;
	  period_set = TRUE;
	}
      }
      if(period*period != length){
	msgerror("Nihilist ciphers must have a square number of letters.");
	period = 0;
	period_set = FALSE;
      }
    }
    else
      period_set = TRUE;

    if(period_set)
      setup_key();
  }

  return period_set;
}

void nihilist::setup_key(){
  int i;

  key.init(period);

  for(i = 0; i < period; i++){
    key.alter(i+'a', i);
  }
}

void nihilist::init_cipher(){
  if(ocipher == NULL){

    clen = period;
    length = strlen(cipher);
  
    ocipher = strdup(cipher);
  
    vert2horiz();
  }
}

void nihilist::show_menu(){
  menu(1, "(M)ove columns/rows  (U)ndo changes  (W)rite   (Q)uit");
}

void nihilist::show_cipher(){
  int i;

  /* Print the row/column numbers
  */

  for(i = 0; i < period; i++)
    msgprint(2*i+2, 0, "%2d", (key.intval(i)+1));
  
  for(i = 0; i < clen; i++)
    msgprint(0, i+2, "%2d", (key.intval(i)+1));

  /* Print the cipher
  */

  for(i = 0; i < length; i++){
    (void)put_char(cipher[i], (i%period)*2+3, (i/period) + 2);
  }
}

void nihilist::move_stuff(){
  char temp_str[STRINGLENGTH];
  char c;
  int column1, column2, i, j;

  prompt("Interchange which two columns/rows? (ex: 1,2) ");
  read_line(temp_str);
  if(sscanf(temp_str, "%d,%d", &column1, &column2) != 2);
  else if(column1 <= period && column2 <= period && column1 > 0 && column2 > 0){
    column1--, column2--;
    /* Find the column that corresponds to what the user entered.
    */
    for(i = 0; i < period && key.intval(i) != column1; i++);
    for(j = 0; j < period && key.intval(j) != column2; j++);

    if(i < period && j < period){
      interchange_columns(i, j);
      interchange_rows(i, j);

      c = key.val(i);
      key.alter(key.val(j), i);
      key.alter(c, j);
    }
  }
  
  else{
    msgerror("Bad column number.");
  }
}

void nihilist::decipher(char *string){
  strcpy(string, cipher);
}

void nihilist::get_cipher(char *string){
  horiz2vert();
  strcpy(string, cipher);
  vert2horiz();
}

/*
void nihilist::solve(){
  int counter = 0;
  Key maxkey;
  int i, value, maxval=0;

  key.duplicate(&maxkey);

  do{
    counter++;
    for(i=1,value=0; i < period; i++){
      value += get_digram_values(block[i-1], block[i]);
    }
    if(value > maxval){
      show_cipher();
      msgerror("%d -> %d", counter, value);
      maxval = value;
      key.duplicate(&maxkey);
    }
  } while(key.advance());
  maxkey.duplicate(&key);
}
*/
