/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

char beaufort::get_key_letter(char ct_letter, char pt_letter){
  char key_letter=(char) NULL;

  ct_letter |= ' ';
  pt_letter |= ' ';

  if(isalpha(ct_letter) && isalpha(pt_letter))
    key_letter = (ct_letter + pt_letter - 'a' - 'a' + 26)%26+'a';
  else
    key_letter = (char) NULL;
  
  return key_letter;
}

char variant::get_key_letter(char ct_letter, char pt_letter){
  char key_letter=(char) NULL;

  ct_letter |= ' ';
  pt_letter |= ' ';

  if(isalpha(ct_letter) && isalpha(pt_letter))
    key_letter = (pt_letter - ct_letter + 26)%26+'a';
  else
    key_letter = (char) NULL;
  
  return key_letter;
}

char vigenere::get_key_letter(char ct_letter, char pt_letter){
  char key_letter=(char) NULL;

  ct_letter |= ' ';
  pt_letter |= ' ';

  if(isalpha(ct_letter) && isalpha(pt_letter))
    key_letter = (ct_letter - pt_letter + 26)%26+'a';
  else
    key_letter = (char) NULL;

  return key_letter;
}

char beaslide::get_key_letter(char ct_letter, char pt_letter){
  char key_letter=(char) NULL;

  ct_letter |= ' ';
  pt_letter |= ' ';

  if(isalpha(ct_letter) && isalpha(pt_letter))
    key_letter = (ct_letter + pt_letter - 'a' - 'a' + 26)%26+'a';
  else
    key_letter = (char) NULL;
  
  return key_letter;
}

char varslide::get_key_letter(char ct_letter, char pt_letter){
  char key_letter=(char) NULL;

  ct_letter |= ' ';
  pt_letter |= ' ';

  if(isalpha(ct_letter) && isalpha(pt_letter))
    key_letter = (pt_letter - ct_letter + 26)%26+'a';
  else
    key_letter = (char) NULL;
  
  return key_letter;
}

char vigslide::get_key_letter(char ct_letter, char pt_letter){
  char key_letter=(char) NULL;

  ct_letter |= ' ';
  pt_letter |= ' ';

  if(isalpha(ct_letter) && isalpha(pt_letter))
    key_letter = (ct_letter - pt_letter + 26)%26+'a';
  else
    key_letter = (char) NULL;

  return key_letter;
}

char bea_autokey::get_key_letter(char ct_letter, char pt_letter){
  char key_letter=(char) NULL;

  ct_letter |= ' ';
  pt_letter |= ' ';

  if(isalpha(ct_letter) && isalpha(pt_letter))
    key_letter = (ct_letter + pt_letter - 'a' - 'a' + 26)%26+'a';
  else
    key_letter = (char) NULL;
  
  return key_letter;
}

char var_autokey::get_key_letter(char ct_letter, char pt_letter){
  char key_letter=(char) NULL;

  ct_letter |= ' ';
  pt_letter |= ' ';

  if(isalpha(ct_letter) && isalpha(pt_letter))
    key_letter = (pt_letter - ct_letter + 26)%26+'a';
  else
    key_letter = (char) NULL;
  
  return key_letter;
}

char vig_autokey::get_key_letter(char ct_letter, char pt_letter){
  char key_letter=(char) NULL;

  ct_letter |= ' ';
  pt_letter |= ' ';

  if(isalpha(ct_letter) && isalpha(pt_letter))
    key_letter = (ct_letter - pt_letter + 26)%26+'a';
  else
    key_letter = (char) NULL;

  return key_letter;
}


char porta::get_key_letter(char ct_letter, char pt_letter){
  char key_letter=(char) NULL;

  ct_letter |= ' ';
  pt_letter |= ' ';

  if(isalpha(ct_letter) && isalpha(pt_letter) && ((ct_letter - pt_letter > 12 || pt_letter - ct_letter > 12))){
    if(ct_letter < pt_letter){
      pt_letter -= 13;
      key_letter = (pt_letter - ct_letter)%13*2 + 'a';
    }
    else{
      ct_letter -= 13;
      key_letter = (ct_letter - pt_letter)%13*2 + 'a';
    }
  }
  else
    key_letter = (char) NULL;

  return key_letter;
}

char variant::get_pt(char ct, char key_letter){
  char pt=(char) NULL;

  ct |= ' ';
  if(isalpha(key_letter)){
    key_letter |= ' ';
    pt = (ct + key_letter - 'a' - 'a'+26)%26 + 'a';
  }
  else
    pt = (char) NULL;

  return pt;
}

char beaufort::get_pt(char ct, char key_letter){
  char pt=(char) NULL;

  ct |= ' ';
  if(isalpha(key_letter)){
    key_letter |= ' ';
    pt = (key_letter - ct + 26)%26 + 'a';
  }
  else
    pt = (char) NULL;

  return pt;
}

char vigenere::get_pt(char ct, char key_letter){
  char pt=(char) NULL;

  ct |= ' ';

  if(isalpha(key_letter)){
    key_letter |= ' ';
    pt = (ct - key_letter + 26)%26 + 'a';
  }
  else
    pt = (char) NULL;

  return pt;
}

char var_autokey::get_pt(char ct, char key_letter){
  char pt=(char) NULL;

  ct |= ' ';
  if(isalpha(key_letter)){
    key_letter |= ' ';
    pt = (ct + key_letter - 'a' - 'a'+26)%26 + 'a';
  }
  else
    pt = (char) NULL;

  return pt;
}

char bea_autokey::get_pt(char ct, char key_letter){
  char pt=(char) NULL;

  ct |= ' ';
  if(isalpha(key_letter)){
    key_letter |= ' ';
    pt = (key_letter - ct + 26)%26 + 'a';
  }
  else
    pt = (char) NULL;

  return pt;
}

char vig_autokey::get_pt(char ct, char key_letter){
  char pt=(char) NULL;

  ct |= ' ';

  if(isalpha(key_letter)){
    key_letter |= ' ';
    pt = (ct - key_letter + 26)%26 + 'a';
  }
  else
    pt = (char) NULL;

  return pt;
}

char varslide::get_pt(char ct, char key_letter){
  char pt=(char) NULL;

  ct |= ' ';
  if(isalpha(key_letter)){
    key_letter |= ' ';
    pt = (ct + key_letter - 'a' - 'a'+26)%26 + 'a';
  }
  else
    pt = (char) NULL;

  return pt;
}

char beaslide::get_pt(char ct, char key_letter){
  char pt=(char) NULL;

  ct |= ' ';
  if(isalpha(key_letter)){
    key_letter |= ' ';
    pt = (key_letter - ct + 26)%26 + 'a';
  }
  else
    pt = (char) NULL;

  return pt;
}

char vigslide::get_pt(char ct, char key_letter){
  char pt=(char) NULL;

  ct |= ' ';

  if(isalpha(key_letter)){
    key_letter |= ' ';
    pt = (ct - key_letter + 26)%26 + 'a';
  }
  else
    pt = (char) NULL;

  return pt;
}

char porta::get_pt(char ct, char key_letter){
  char pt=(char) NULL;

  if(isalpha(key_letter) && isalpha(ct)){
    key_letter |= ' ';
    key_letter -= 'a';
    key_letter /= 2;

    ct |= ' ';
    ct -= 'a';

    if(ct < 13){
      pt = (ct + key_letter)%13+'n';
    }
    else{
      ct -= 13;
      pt = (ct - key_letter + 13)%13+'a';
    }
  }
  else
    pt = (char) NULL;

  return pt;
}

char variant::get_ct(char pt, char key_letter){
  char ct=(char) NULL;

  pt |= ' ';

  if(isalpha(key_letter)){
    key_letter |= ' ';
    ct = (pt - key_letter + 26)%26 + 'a';
  }
  else
    ct = (char) NULL;

  return ct;
}

char beaufort::get_ct(char pt, char key_letter){
  char ct=(char) NULL;

  pt |= ' ';

  if(isalpha(key_letter)){
    key_letter |= ' ';
    ct = (key_letter - pt + 26)%26 + 'a';
  }
  else
    ct = (char) NULL;

  return ct;
}

char vigenere::get_ct(char pt, char key_letter){
  char ct=(char) NULL;

  pt |= ' ';

  if(isalpha(key_letter)){
    key_letter |= ' ';
    ct = (pt + key_letter - 'a' - 'a'+26)%26 + 'a';
  }
  else
    ct = (char) NULL;

  return ct;
}

char varslide::get_ct(char pt, char key_letter){
  char ct=(char) NULL;

  pt |= ' ';

  if(isalpha(key_letter)){
    key_letter |= ' ';
    ct = (pt - key_letter + 26)%26 + 'a';
  }
  else
    ct = (char) NULL;

  return ct;
}

char beaslide::get_ct(char pt, char key_letter){
  char ct=(char) NULL;

  pt |= ' ';

  if(isalpha(key_letter)){
    key_letter |= ' ';
    ct = (key_letter - pt + 26)%26 + 'a';
  }
  else
    ct = (char) NULL;

  return ct;
}

char vigslide::get_ct(char pt, char key_letter){
  char ct=(char) NULL;

  pt |= ' ';

  if(isalpha(key_letter)){
    key_letter |= ' ';
    ct = (pt + key_letter - 'a' - 'a'+26)%26 + 'a';
  }
  else
    ct = (char) NULL;

  return ct;
}

char var_autokey::get_ct(char pt, char key_letter){
  char ct=(char) NULL;

  pt |= ' ';

  if(isalpha(key_letter)){
    key_letter |= ' ';
    ct = (pt - key_letter + 26)%26 + 'a';
  }
  else
    ct = (char) NULL;

  return ct;
}

char bea_autokey::get_ct(char pt, char key_letter){
  char ct=(char) NULL;

  pt |= ' ';

  if(isalpha(key_letter)){
    key_letter |= ' ';
    ct = (key_letter - pt + 26)%26 + 'a';
  }
  else
    ct = (char) NULL;

  return ct;
}

char vig_autokey::get_ct(char pt, char key_letter){
  char ct=(char) NULL;

  pt |= ' ';

  if(isalpha(key_letter)){
    key_letter |= ' ';
    ct = (pt + key_letter - 'a' - 'a'+26)%26 + 'a';
  }
  else
    ct = (char) NULL;

  return ct;
}

char porta::get_ct(char pt, char key_letter){
  return get_pt(pt, key_letter);
}
