/* this is where all of the different key classes are defined
*/
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "types.h"

static int charcmp(const char *a, const char *b){
  return (int) (*a - *b);
}

class Key{
  private:
  int keylen1, keylen2;
  char **key;

  public:
  Key(){
    key = NULL;
  }

  void init(int length1 = 26, int length2 = 1){
    int i, j;

    /* erase the old key
    */
    if(key != NULL){
      for(i = 0; i < keylen2; i++)
	delete[] key[i];
      delete[] key;
    }

    /* allocate the new key
    */
    key = new char*[length2];
    for(i = 0; i < length2; i++){
      key[i] = new char[length1];
    }

    /* initialize the new key
    */
    keylen1 = length1;
    keylen2 = length2;
    for(i = 0; i < keylen1; i++){
      for(j = 0; j < keylen2; j++){
	key[j][i] = BLANK;
      }
    }
  };

  void clearkey(void){
    int i, j;
    for(i = 0; i < keylen1; i++){
      for(j = 0; j < keylen2; j++){
	key[j][i] = BLANK;
      }
    }
  };

  void clearkey(char index1, char index2 = 'a'){
    if(isalpha(index1) && isalpha(index2)){
      key[(int) (index2-'a')][(int) (index1 - 'a')] = BLANK;
    }
  };

  void clearkey(int index1, int index2 = 0){
    key[index2][index1] = BLANK;
  };

  char val(char index1, char index2 = 'a'){
    char value = (char) NULL;

    if(isalpha(index1)) index1 -= 'a';
    if(isdigit(index1)) index1 -= '0';
    if(isalpha(index2)) index2 -= 'a';
    if(isdigit(index2)) index2 -= '0';

    if(index1 >= 0 && index1 < keylen1 && index2 >= 0 && index2 < keylen2){
      value = key[index2][index1];
    }

    return value;
  };

  char val(int index1, int index2 = 0){
    char value = (char) NULL;

    if(index1 >= 0 && index1 < keylen1 && index2 >= 0 && index2 < keylen2){
      value = key[index2][index1];
    }

    return value;
  };

  int intval(char index1, char index2 = 'a'){
    char value = (char) NULL;

    if(isalpha(index1)) index1 -= 'a';
    if(isdigit(index1)) index1 -= '0';
    if(isalpha(index2)) index2 -= 'a';
    if(isdigit(index2)) index2 -= '0';

    if(index1 >= 0 && index1 < keylen1 && index2 >= 0 && index2 < keylen2){
      value = key[index2][index1];
      if(isalpha(value)) value -= 'a';
      if(isdigit(value)) value -= '0';
    }

    return (int) value;
  };

  int intval(int index1, int index2 = 0){
    char value = (char) NULL;

    if(index1 >= 0 && index1 < keylen1 && index2 >= 0 && index2 < keylen2){
      value = key[index2][index1];
      if(isalpha(value)) value -= 'a';
      if(isdigit(value)) value -= '0';
    }

    return (int) value;
  };

  void duplicate(Key *copy){
    int i, j;

    copy->init(keylen1, keylen2);
    for(i = 0; i < keylen1; i++){
      for(j = 0; j < keylen2; j++){
	copy->alter(key[j][i], i, j);
      }
    }
  }

  int index(char value){
    if(isalpha(value)){
      value -= 'a';
    }
    else if(isdigit(value)){
      value -= '0';
    }
    else{
      value = -1;
    }

    return (int) value;
  }

  int alter(char value, int index1, int index2=0){
    char status = NEW_SUB;

    if(!isalnum(value)){
      status = BAD_SUB;
    }
    else{
      if(index1 < 0 || index1 >= keylen1 || index2 < 0 || index2 >= keylen2){
        status = BAD_SUB;
      }
      else{ 
        if(key[index2][index1] != BLANK && key[index2][index1] != value){
	  status = ALT_SUB;
	}
	key[index2][index1] = value;
      }
    }

    return status;
  };

  void string(char *string){
    int i;

    for(i = 0; i < keylen2; i++){
      strncpy(string+i*keylen1, key[i], keylen1);
    }
    string[keylen1*keylen2] = (char) NULL;
  };

  void restore(char *string){
    int i, j;

    for(i = 0; i < keylen1; i++){
      for(j = 0; j < keylen2; j++){
	key[j][i] = *string++;
      }
    }
  };

  int advance(int index2 = 0){
    char *pt1, *pt2, tval;
    int i;

    for(i = 1; i < keylen1 && key[index2][i] < key[index2][i-1]; i++);
    if(i < keylen1){
      pt1 = key[index2]+i;
      for(pt2 = pt1; pt2 != key[index2] && *(pt2-1) <= *pt1; pt2--);
      tval = *pt2;
      *pt2 = *pt1;
      *pt1 = tval;
      qsort((void *) key[index2], (size_t) (pt1-key[index2]), sizeof(char), charcmp);
    }

    /* This will be zero as soon as we are finished */
    return keylen1-i;
  };
};
