/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "term.h"
#include "digram.h"

static int digram_freq[26][26] = { { 1, 8, 44, 45, 131, 21, 11, 84, 18, 0, 0, 34, 
      56, 54, 9, 21, 0, 57, 75, 56, 18, 15, 32, 3, 11, 0},
    { 32, 0, 0, 18, 11, 2, 2, 1, 7, 0, 0, 7, 9, 
      7, 18, 1, 0, 4, 13, 14, 5, 0, 0, 0, 11, 0},
    { 39, 0, 12, 4, 64, 9, 1, 2, 55, 0, 0, 8, 1, 
      31, 18, 0, 0, 14, 21, 6, 17, 0, 3, 5, 10, 0},
    { 15, 0, 0, 10, 107, 1, 1, 1, 16, 0, 0, 28, 2, 
      118, 16, 0, 0, 16, 6, 9, 11, 0, 4, 0, 4, 0},
    { 0, 58, 55, 39, 39, 25, 32, 251, 37, 2, 28, 72, 48, 
      64, 3, 40, 0, 148, 84, 94, 11, 53, 30, 1, 12, 5},
    { 10, 0, 1, 12, 23, 14, 3, 2, 27, 0, 0, 5, 0, 
      8, 94, 0, 0, 6, 13, 5, 1, 0, 1, 0, 3, 0},
    { 18, 0, 0, 2, 20, 1, 1, 0, 10, 0, 0, 1, 0, 
      75, 3, 0, 0, 6, 6, 1, 12, 0, 0, 0, 5, 0},
    { 0, 0, 46, 3, 15, 6, 16, 5, 0, 0, 0, 0, 1, 
      9, 3, 7, 0, 3, 30, 315, 2, 0, 48, 0, 5, 0},
    { 16, 6, 15, 57, 40, 21, 10, 72, 0, 0, 8, 57, 26, 
      37, 13, 8, 0, 77, 42, 128, 5, 19, 37, 4, 18, 2},
    { 0, 2, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 
      3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0},
    { 10, 0, 8, 0, 2, 0, 0, 0, 8, 0, 0, 3, 0, 
      3, 5, 0, 0, 11, 2, 0, 0, 0, 0, 0, 0, 0},
    { 77, 21, 16, 7, 46, 10, 4, 3, 39, 0, 0, 55, 0, 
      10, 17, 29, 0, 12, 6, 12, 28, 0, 4, 0, 6, 1},
    { 18, 1, 0, 9, 43, 3, 1, 1, 32, 0, 0, 4, 5, 
      7, 44, 0, 0, 15, 14, 14, 9, 0, 1, 0, 4, 0},
    { 172, 0, 0, 5, 120, 2, 3, 2, 169, 0, 3, 1, 3, 
      9, 145, 0, 0, 12, 19, 8, 33, 0, 10, 0, 3, 0},
    { 2, 11, 59, 37, 46, 38, 23, 46, 63, 4, 3, 28, 28, 
      65, 23, 28, 0, 54, 71, 111, 2, 6, 17, 1, 28, 0},
    { 31, 0, 1, 7, 32, 3, 1, 1, 3, 0, 0, 2, 16, 
      7, 29, 26, 0, 8, 24, 8, 17, 0, 2, 4, 7, 0},
    { 1, 0, 0, 1, 14, 0, 0, 0, 0, 0, 0, 2, 0, 
      0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0},
    { 101, 6, 7, 10, 154, 4, 21, 8, 21, 0, 0, 2, 0, 
      5, 113, 42, 0, 18, 6, 30, 49, 0, 1, 0, 5, 0},
    { 67, 5, 1, 32, 145, 8, 7, 3, 106, 0, 2, 12, 6, 
      51, 37, 3, 0, 39, 41, 32, 42, 0, 3, 0, 17, 0},
    { 124, 0, 38, 39, 80, 42, 13, 22, 88, 0, 1, 19, 6, 
      110, 53, 14, 0, 63, 121, 53, 45, 0, 6, 1, 21, 0},
    { 12, 25, 16, 8, 7, 11, 8, 2, 0, 4, 0, 8, 13, 
      12, 96, 7, 20, 6, 30, 22, 0, 0, 1, 1, 1, 0},
    { 24, 0, 0, 4, 16, 1, 0, 0, 14, 0, 0, 2, 0, 
      4, 13, 0, 0, 5, 2, 4, 0, 0, 1, 0, 3, 0},
    { 7, 0, 1, 9, 41, 4, 2, 7, 1, 0, 3, 5, 2, 
      15, 36, 1, 0, 10, 27, 16, 0, 0, 2, 0, 14, 0},
    { 0, 0, 0, 0, 17, 0, 0, 0, 1, 0, 0, 0, 0, 
      1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0},
    { 27, 19, 0, 6, 17, 1, 1, 1, 0, 0, 3, 47, 3, 
      14, 4, 2, 0, 17, 4, 21, 1, 0, 0, 0, 0, 0},
    { 1, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 
      0, 2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1} };

int get_digram_value(char pt1, char pt2){
  int value = 0;

  if(isalpha(pt1) && isalpha(pt2)){
    pt1 |= ' ';
    pt2 |= ' ';
    value = digram_freq[pt2-'a'][pt1-'a'];
  }

  return value;
}

int get_digram_values(char *pt1, char *pt2){
  int i, value=0;

  for(i = 0; pt1[i] && pt2[i]; i++){
    value += get_digram_value(pt1[i], pt2[i]);
  }

  return value;
}

int find_best_fit(char *string1, char *string2){
  int bestrot = 0, maxval = 0, value = 0;
  int len1, len2;
  int i, j;

  len1 = strlen(string1);
  len2 = strlen(string2);

  for(i = 0; i < len1 && len1 == len2; i++){
    for(j = 0, value = 0; j < len1; j++){
      value += get_digram_value(string1[j], string2[(i+j)%len2]);
    }
    if(value > maxval){
      maxval = value;
      bestrot = i;
    }
  }

  return len2-bestrot;
}
