/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

cipherdata::cipherdata(){
  valid_chars = "abcdefghijklmnopqrstuvwxyz";
}

char cipherdata::read_header(FILE *fptr){
  char temp_str[STRINGLENGTH];

  /* Are we reading from a saved file?
  */
  (void)fgets(temp_str, STRINGLENGTH, fptr);
  if(strrchr(temp_str, '\n'))
    *strrchr(temp_str, '\n') = (char) NULL;

  if(strcmp(SAVE_HEADER, temp_str) == 0){
    (void) fgets(temp_str, STRINGLENGTH, fptr);
    *strrchr(temp_str, '\n') = (char) NULL;
    (void) sscanf(temp_str, "%c", &type);
  }
  else
    type = (char) NULL;

  return type;
}

int cipherdata::read_cipher(FILE *fptr){
  char temp_str[STRINGLENGTH];
  int broken = FALSE, newperiod;

  /* Are we reading from a saved file?
  */
  (void)fgets(temp_str, STRINGLENGTH, fptr);
  if(strrchr(temp_str, '\n'))
    *strrchr(temp_str, '\n') = (char) NULL;

  if(strcmp(SAVE_HEADER, temp_str) == 0){

    (void)fgets(temp_str, STRINGLENGTH, fptr);
    *strrchr(temp_str, '\n') = (char) NULL;
    sscanf(temp_str, "%c", &type);

    (void)fgets(temp_str, STRINGLENGTH, fptr);
    *strrchr(temp_str, '\n') = (char) NULL;
    sscanf(temp_str, "%d", &newperiod);

    if(set_period(newperiod) == FALSE){
      unready_term();
      putchar('\n');
      exit(0);
    }

    fgets(temp_str, STRINGLENGTH, fptr);
    *strrchr(temp_str, '\n') = (char) NULL;
    key.restore(temp_str);

    while(*temp_str != SAVE_DELIMITER)
      (void)fgets(temp_str, STRINGLENGTH, fptr);
  }
  else
    (void)rewind(fptr);

  /* Read in the cipher
  */

  length = get_cipher_from_file(fptr);

  if(set_period() == FALSE){
    unready_term();
    putchar('\n');
    exit(0);
  }
  init_cipher();

  return broken;
}

int cipherdata::get_cipher_from_file(FILE *fptr){
  int count=0;
  char c;

  while(!feof(fptr) && count < CLENGTH){
    c = getc(fptr);
    if(isalpha(c)){
      c |= ' ';
    }
    if(c == '\n' || c == '\r' || c == '\t'){
      c = ' ';
    }
    if(strchr(valid_chars, c)){
      cipher[count++] = c;
    }
  }
  if(count >= CLENGTH){
    msgerror("Cipher too long.  Truncating.");
  }
  cipher[count] = (char) NULL;

  return count;
}

void cipherdata::write_cipher(){
  char temp_str[CLENGTH];
  char ifile[STRINGLENGTH];
  FILE *tfptr, *ifptr;

  *temp_str = 'y';
  prompt("Save to which file? ");
  read_line(ifile);
  ifptr = fopen(ifile, "r");
  tfptr = NULL;

  /* Does the file already exist?
  */

  if(ifptr){
    /* If so, overwrite?
    */

    prompt("File already exists.  Overwrite? ");
    if( (*temp_str = get_char()|' ') != 'y'){
      msgerror("Cipher not saved.");
    }
  }
  if(*temp_str == 'y'){
    /* Can we write to the file?
    */
    tfptr = fopen(ifile, "w");
    if(!tfptr){
      msgerror("Could not open file for writing.");
    }
    else{
      fprintf(tfptr, "%s\n", SAVE_HEADER);
      fprintf(tfptr, "%c\n", type);
      fprintf(tfptr, "%d\n", period);

      key.string(temp_str);
      fprintf(tfptr, "%s\n", temp_str);

      decipher(temp_str);
      fprintf(tfptr, "%s\n", temp_str);

      fprintf(tfptr, "%c\n", SAVE_DELIMITER);

      get_cipher(temp_str);

      fprintf(tfptr, "%s\n", temp_str);

      msgerror("Cipher saved.") ;
    }
  }
  else
    msgerror("Cipher not saved.");

  if(ifptr)
    (void) fclose(ifptr);
  if(tfptr)
    (void) fclose(tfptr);
}

void cipherdata::get_cipher(char *string){
  strcpy(string, cipher);
}

int cipherdata::base_exec_option(char option){
  int valid = TRUE;

  switch(option){
    case DUMP:
      dump_screen();
      break;
    case SAVE:
      write_cipher();
      break;
    case QUIT:
      break;
    default:
      valid = FALSE;
      break;
  }

  return valid;
}

int cipherdata::set_period(int newperiod){
  char temp_str[STRINGLENGTH];

  if(period_set == FALSE || newperiod){
    period = newperiod;
    while(period == 0){
      prompt("What is the new period of this %d-letter cipher? ", length);
      read_line(temp_str);
      (void) sscanf(temp_str, "%d", &period);
      if(! period_valid()){
	period = 0;
      }
    }

    setup_key();
    period_set = TRUE;
  }

  return period_set;
}

int cipherdata::period_valid(){
  return (period > 0)?TRUE:FALSE;
}

void cipherdata::dump_screen(){
  char screen_data[STRINGLENGTH];
  char temp_str[CLENGTH];
  char ifile[STRINGLENGTH];
  FILE *tfptr, *ifptr;

  *temp_str = 'y';
  prompt("Dump screen contents to which file? ");
  read_line(ifile);
  ifptr = fopen(ifile, "r");
  tfptr = NULL;

  /* Does the file already exist?
  */

  if(ifptr){
    /* If so, overwrite?
    */

    prompt("File already exists.  Overwrite? ");
    if( (*temp_str = get_char()|' ') != 'y'){
      msgerror("Screen contents not dumped.");
    }
  }
  if(*temp_str == 'y'){
    /* Can we write to the file?
    */
    tfptr = fopen(ifile, "w");
    if(!tfptr){
      msgerror("Could not open file for writing.");
    }
    else{
      while(get_screen_contents(screen_data)){
	length = strlen(screen_data);
	while(screen_data[--length] == ' ');
	screen_data[length+1] = (char) NULL;
        fprintf(tfptr, "%s\n", screen_data);
      }
    }
  }
}
