#include "keys.h"

class cipherdata {
  private:
  char type;

  protected:
  Key key;
  char cipher[CLENGTH];
  char *valid_chars;
  int length;
  int period;
  int period_set;

  /* Executes options not defined in the cipher class */
  int base_exec_option(char option);

  /* Writes the cipher to a file */
  void write_cipher(void);

  /* Read a cipher from a file.  Only characters from the valid_chars[]
  ** array are used.  */
  int get_cipher_from_file(FILE *fptr);

  /* Used in set_period(void) to determine if the current period is valid. */
  virtual int period_valid(void);

  /* Used in read_cipher(void) to:
      a) Set the period of a saved cipher
      b) Determine the period of a new cipher (or get the period from user)
      c) Used in cipher class to change the current period.  */
  virtual int set_period(int newperiod=0);

  /* Copy the key or decoded cipher to a single character array for
  ** printing to the save file. */
  virtual void decipher(char *string){};

  /* Copy the original cipher to a character array */
  virtual void get_cipher(char *string);

  /* Used in read_cipher to initialize/reset remaining variables and
  ** perform any pre-solving operations on the cipher.  Also used for 
  ** resetting cipher variables when necessary, such as when the period 
  ** is changed.  For example, columnar.c uses it to fill in the 
  ** initial Myszkowski block. */
  virtual void init_cipher(void){};

  /* Initializes the key */
  virtual void setup_key(void){};

  /* Dump the contents of the screen to a file */
  void dump_screen(void);

  public:
  cipherdata(void);
  char read_header(FILE *fptr);
  int read_cipher(FILE *fptr);
  void set_type(char ctype){ type = ctype; };
  virtual int execute_option(char option){ return 0;};
  virtual void show_cipher(void){};
  virtual void show_key(void){};
  virtual void show_menu(void){};
};

class transposition:public cipherdata {
  protected:
  int clen;
  char *ocipher;

  char *get_column_string(int column);
  void undo(void);
  void horiz2vert(void);
  void interchange_columns(int column1, int column2);
  void interchange_rows(int row1, int row2);
  void rotate_column(int column, int amount);
  void vert2horiz(void);
};
  


class baconian:public cipherdata {
  int period;
  char *balphabet[26];

  int set_period(int);
  int is_valid_sub(char flag, char letter);
  int sub_string(char letter1, char *string);
  void bconv(char letter, char btext[6]);
  void bdeconv(char btext[6]);
  void bstringtochar(char *string);
  void decipher(char *string);
  void groupsub(void);
  void init_cipher(void){};
  void locate_tip(void);
  void stringtob(char *string);
  void substitute(void);
  void undo(void);
  void undo_letter(char letter);

  public:
  baconian(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class homophonic:public cipherdata {
  Key best_fits;
  int ocipher[CLENGTH];
  int hist[4][25];

  char get_pt(int number);
  int fit_hist(int newhist[25]);
  int set_period(int newperiod){ return (period_set = TRUE);};
  void alphfit(void);
  void decipher(char *string);
  void decode(char *message);
  void init_cipher(void);
  void shift_row(int row, int amount);
  void sub_letter(int number, char lettr);
  void substitute(void);
  void undo(void);

  public:
  homophonic(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class grandpre:public cipherdata{
  int hist[8][8];
  int ocipher[CLENGTH];

  char get_pt(int num);
  int isvalidtip(char *tip);
  int set_period(int newperiod){ return (period_set = TRUE);};
  void decipher(char *string);
  void init_cipher(void);
  void keydup(char tkey1[8][8], char tkey2[8][8]);
  void locate_tip(void);
  void substitute(void);
  void undo(void);

  public:
  grandpre(void);
  int execute_option(char option);
  void show_menu(void);
  void show_cipher(void);
  void show_key(void);
};

class autokey_base:public cipherdata{
  protected:

  int execute_option(char option);
  virtual char get_ct(char pt, char key_letter){return (char) NULL; };
  virtual char get_key_letter(char ct, char pt){return (char) NULL; };
  virtual char get_pt(char ct, char key_letter){return (char) NULL; };
  void alphfit(void);
  void change_period(void);
  void decipher(char *string);
  void fit_all_columns(void);
  void fit_column(int column);
  void setup_key(void);
  void sub_letter(char ct_letter, char pt_letter, int column);
  void substitute(void);
  void undo(void);

  private:
  autokey_base(void);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class vig_autokey:public autokey_base{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);
};

class var_autokey:public autokey_base{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);
};

class bea_autokey:public autokey_base{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);
};

class slidefair_base:public cipherdata{
  protected:

  virtual char get_ct(char pt, char key_letter){return (char) NULL; };
  virtual char get_key_letter(char ct, char pt){return (char) NULL; };
  virtual char get_pt(char ct, char key_letter){return (char) NULL; };
  char slide_get_key_letter(char ct_1, char ct_2, char pt_1, char pt_2);
  char *slide_get_ct(char pt1, char pt2, char key_letter);
  char *slide_get_pt(char ct1, char ct2, char key_letter);
  int execute_option(char option);
  void alphfit(void);
  void change_period(void);
  void decipher(char *string);
  void decode(char *message);
  void fit_column(int column);
  void setup_key(void);
  void sub_digraph(char ct_1, char ct_2, char pt_1, char pt_2, int column);
  void substitute(void);
  void undo(void);

  public:
  slidefair_base(void);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class vigslide:public slidefair_base{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);
};

class beaslide:public slidefair_base{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);
};

class varslide:public slidefair_base{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);
};

class vigenere_base:public cipherdata {
  protected:

  virtual char get_ct(char pt, char key_letter){return (char) NULL; };
  virtual char get_key_letter(char ct, char pt){return (char) NULL; };
  virtual char get_pt(char ct, char key_letter){return (char) NULL; };
  void alphfit(void);
  void change_period(void);
  void decipher(char *string);
  void decode(char *message);
  void fit_all_columns(void);
  void fit_column(int column);
  void setup_key(void);
  void sub_letter(char ct_letter, char pt_letter, int column);
  void substitute(void);
  void undo(void);

  public:
  vigenere_base(void);
  virtual void show_key(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_menu(void);
};

class vigenere:public vigenere_base{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);
};

class beaufort:public vigenere_base{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);
};

class variant:public vigenere_base{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);
};

class porta:public vigenere_base{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);

  public:
  void show_key(void);
};

class checker:public cipherdata{
  Key keywords;
  char newcipher[CLENGTH], block[5][5];
  int num_keys;

  int set_period(int newperiod);
  void checker2aris(void);
  void decipher(char *string);
  void init_cipher(void);
  void sub(void);
  void undo(void);

  public:
  checker(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class aristocrat:public cipherdata{
  char **ocipher;
  int num_lines;

  int set_period(int newperiod);
  void decipher(char *string);
  void group_substitute(void);
  void init_cipher(void);
  void locate_tip(void);
  void substitute(void);
  void undo(void);

  public:
  aristocrat(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class quag:public cipherdata {
  Key okey;
  int clen;

  int alter_key(int keynum, char ct_letter, char pt_letter);
  void change_period(void);
  void clear_key(int keynum);
  void decipher(char *string);
  void decode(char *message);
  void setup_key(void);
  void substitute(void);
  void undo(void);
  void undo_letter(int keynum, char letter);

  public:
  quag(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class nihilist:public transposition {

  int set_period(int newperiod);
  void decipher(char *string);
  void get_cipher(char *string);
  void init_cipher(void);
  void move_stuff(void);
  void setup_key(void);

  public:
  nihilist(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void){};
  void show_menu(void);
};

class cadenus:public transposition {

  char cad_conv(char letter){ return (letter > 'v')?letter+1:letter;};
  char cad_deconv(char letter){ return (letter > 'v')?letter-1:letter;};
  int set_period(int period);
  void decipher(char *string);
  void fit_columns(void);
  void _fit_columns(int column1, int column2);
  void init_cipher(void);
  void move_stuff(void);
  void rotate(void);
  void _rotate_column(int column, int amount);
  void setup_key(void);

  public:
  cadenus(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class phillips:public cipherdata {
  int philsquares[8][5];

  int set_period(void);
  void clear_key(void);
  void decipher(char *string);
  void decrypt(char *string, int square);
  void init_cipher(void);
  void substitute(void);
  void undo(void);
  void undo_letter(char letter);

  public:
  phillips(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class swagman:public cipherdata {
  int num_squares;

  int period_valid(void);
  void change_period(void);
  void clear_key(void);
  void decipher(char *string);
  void move_stuff(void);
  void setup_key(void);
  void substitute(void);
  void undo(void);
  void update_key(char number, int row, int column);

  public:
  swagman(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_menu(void);
};

class railfence:public cipherdata {
  protected:
  int maxraillen;
  int keylen;
  int *clen;
  char **block;
  Key okey;

  int *find_columns(int index);
  int period_valid(void);
  void change_rails(void);
  void decipher(char *string);
  void fill_block(void);
  void init_cipher(void);
  void move_startpos(void);
  void setup_key(void);
  void set_key(int startpos);
  virtual void move_stuff(void);

  public:
  railfence(void);
  int execute_option(char option);
  void show_menu(void);
  void show_cipher(void);
  void show_key(void);
};

class redefence:public railfence {
  void move_stuff(void);
  void interchange_rails(void);
};

class columnar:public cipherdata {
  int maxcollen;
  int *clen;
  char **block;

  int advance_key(void);
  int *find_columns(int index);
  int execute_option(char option);
  void change_period(void);
  void decipher(char *string);
  void fill_block(void);
  void find_best_fit(void);
  void init_cipher(void);
  void init_key(void);
  void keydup(int *key1, int *key2);
  void move_stuff(void);
  void rotate_key(void);
  void setup_key(void);
  void undo(void);

  public:
  columnar(void);
  void show_menu(void);
  void show_cipher(void);
  void show_key(void){};
};

class morse:public cipherdata {
  protected:
  int keylen;

  char morse2roman(char *morsestring);
  inline char *num2morse(int num);
  inline int is_valid_spc_dist(const char *string);
  int empty_string(char *string);
  int morse2num(char *string);
  int valid_pattern(char *pattern);
  virtual char *get_morse(char value);
  virtual int period_valid(void);
  virtual void do_sub(char number, int pattern);
  virtual void solve(void){};
  virtual void substitute(void);
  virtual void undo(void){};
  void decipher(char *string);
  void decrypt(char *string);
  void setup_key(void){};

  public:
  morse(void);
  int execute_option(char option);
  void show_cipher(void);
  virtual void show_key(void){};
  virtual void show_menu(void){};
};

class pollux:public morse{
  int set_period(int newperiod=0);
  void solve(void);
  void substitute(void);
  void undo(void);

  /* These are used for the word searching routines
  */

  Key maxkey, tkey;
  int max_value;

  void rec_digram_fit(int pos);

  public:
  pollux(void);
  void show_menu(void);
  void show_key(void);
};

class morbit:public morse{
  int set_period(int newperiod=0);
  void undo(void);
  void solve(void);
  char *get_morse(char value);

  public:
  morbit(void);
  void show_key(void);
  void show_menu(void);
};

class fmorse:public morse{
  int set_period(int newperiod=0);
  void do_sub(char letter, int pattern);
  void undo(void);

  public:
  fmorse(void);
  void show_key(void);
  void show_menu(void);
};

class tridigit:public cipherdata{
  char space_digit;

  int execute_option(char option);
  int get_letters(char number, char lets[3]);
  int do_sub(char number, char letter);
  int set_period(int newperiod=0){ return (period_set = TRUE); };
  void decipher(char *string);
  void decrypt(char *message);
  void substitute(void);
  void undo(void);

  public:
  tridigit(void);
  void show_menu(void);
  void show_cipher(void);
  void show_key(void);
};

class keyphrase:public cipherdata{
  char **ocipher;
  int num_lines;

  int execute_option(char option);
  int set_period(int newperiod);
  void undo(void);
  void decipher(char *string);
  void get_letters(char letter, char *array);
  void group_substitute(void);
  void init_cipher(void);
  void locate_tip(void);
  void substitute(void);
  
  public:
  void show_cipher(void);
  void show_menu(void);
  void show_key(void);
  keyphrase(void);
};
