/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

#define S1          {1, 2, 3, 4, 5}
#define S2          {2, 1, 3, 4, 5}
#define S3          {2, 3, 1, 4, 5}
#define S4          {2, 3, 4, 1, 5}
#define S5          {2, 3, 4, 5, 1}
#define S6          {3, 2, 4, 5, 1}
#define S7          {3, 4, 2, 5, 1}
#define S8          {3, 4, 5, 2, 1}

phillips::phillips(){
  cipher[0] = (char) NULL;
  period = 5;
  period_set = TRUE;
  key.init(5, 5);
}

int phillips::set_period(){
  period = 5;
  period_set = TRUE;

  return period_set;
}

void phillips::init_cipher(){
  length = strlen(cipher);
  period = 5;
}

int phillips::execute_option(char option){
  int valid = TRUE;

  switch(option){
    case SUBSTITUTE:
      substitute();
      break; 
    case UNDO:
      undo();
      break;
    default:
      valid = base_exec_option(option);
      break;
  }

  return valid;
}

void phillips::substitute(){
  int row, column;
  char letter, tmp_str[STRINGLENGTH];

  prompt("What are the coordinates of the letter? (row,column) ");
  read_line(tmp_str);
  sscanf(tmp_str, "%d,%d", &row, &column);
  if(row < 1 || row > 5 || column < 1 || column > 5)
    msgerror("Bad position.");
  else{
    prompt("What is the new letter? ");
    letter = get_char();
    if(!isalpha(letter))
      msgerror("Bad letter.");
    else{
      key.alter(letter, row-1, column-1);
    }
  }
}

void phillips::undo(){
  char letter;

  prompt("Undo which letter? (* for all) ");
  letter = get_char();
  if(letter == '*')
    key.clearkey();
  else
    key.clearkey(letter);
}

void phillips::show_menu(){
  menu(1, "Options:  (S)ubstitute      (U)ndo letter    (W)rite    (Q)uit");
}

void phillips::show_key(){
  const int squares[8][5] = { S1, S2, S3, S4, S5, S6, S7, S8};
  int i, j, k;

  /* Loop through rows...  */
  for(i = 0; i < 5; i++){
    /* Loop through the 4 squares in each row... */
    for(j = 0; j < 4; j++){
      /* Label each row */
      put_char(squares[j][i]+'0', j*14, i);
      put_char('>', j*14+1, i);
      put_char(squares[j+4][i]+'0', j*14, i+6);
      put_char('>', j*14+1, i+6);
      /* Loop through the 5 letters in each row... */
      for(k = 0; k < 5; k++){
	put_char(key.val(k, squares[j][i]-1), j*14+2*k+2, i);
	put_char(key.val(k, squares[j+4][i]-1), j*14+2*k+2, i+6);
      }
    }
  }
}

void phillips::show_cipher(){
  int i=0;
  char tmp_str[STRINGLENGTH];

  while(i < length){
    strncpy(tmp_str, cipher+i, 5);
    msgprint((i*6/5)%72, 12+(i/60)*3, tmp_str);
    decrypt(tmp_str, ((i/5)%8));
    msgprint((i*6/5)%72, 11+(i/60)*3, tmp_str);
    put_char( ((i/5)%8)+'1', (i*6/5)%72+2, 13+(i/60)*3);
    i += 5;
  }
}

void phillips::decrypt(char *message, int snum){
  int skey[8][5] = { S1, S2, S3, S4, S5, S6, S7, S8};
  int i, j, k;
  int letter_replaced;
  char c;

  /* Loop through each letter... */
  for(i = 0; i < 5; i++){
    letter_replaced = FALSE;
    /* If the letter exists in the keysquare then find it's partner.
    ** Otherwise, (or if the partner doesn't exist) leave it blank.
    */
    if(message[i] != ' '){
      for(j = 0; j < 5; j++){
	for(k = 0; k < 5; k++){
	  if(message[i] == key.val(k, skey[snum][j]-1) && letter_replaced == FALSE){
	    letter_replaced = TRUE;
	    c = key.val(((k==0)?4:k-1), skey[snum][((j==0)?4:j-1)]-1);
	    if(c != BLANK)
	      message[i] = c;
	    else
	      message[i] = ' ';
	  }
	}
      }
      if(!letter_replaced)
	message[i] = ' ';
    }
  }
}

void phillips::decipher(char *string){
  int i=0;
  char tmp_str[STRINGLENGTH];

  *string = (char) NULL;
  while(i < length){
    strncpy(tmp_str, cipher+i, 5);
    tmp_str[5] = (char) NULL;
    decrypt(tmp_str, ((i/5)%8));
    strcat(string, tmp_str);
    put_char( ((i/5)%8)+'1', (i*6/5)%72+2, 13+(i/60)*3);
    i += 5;
  }
}
