/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

#define AFLAG       'a'
#define BFLAG       'b'

baconian::baconian(){
  /*
  char *balphabet[26] = { "aaaaa", "aaaab", "aaaba", "aaabb", "aabaa",
	  "aabab", "aabba", "aabbb", "abaaa", "abaaa", "abaab", 
	  "ababa", "ababb", "abbaa", "abbab", "abbba", "abbbb",
	  "baaaa", "baaab", "baaba", "baabb", "baabb", "babaa", 
	  "babab", "babba", "babbb"};
  */
  key.init(26);
  period = 5;
  balphabet[0] = "aaaaa";
  balphabet[1] = "aaaab";
  balphabet[2] = "aaaba";
  balphabet[3] = "aaabb";
  balphabet[4] = "aabaa";
  balphabet[5] = "aabab";
  balphabet[6] = "aabba";
  balphabet[7] = "aabbb";
  balphabet[8] = "abaaa";
  balphabet[9] = "abaaa";
  balphabet[10] = "abaab";
  balphabet[11] = "ababa";
  balphabet[12] = "ababb";
  balphabet[13] = "abbaa";
  balphabet[14] = "abbab";
  balphabet[15] = "abbba";
  balphabet[16] = "abbbb";
  balphabet[17] = "baaaa";
  balphabet[18] = "baaab";
  balphabet[19] = "baaba";
  balphabet[20] = "baabb";
  balphabet[21] = "baabb";
  balphabet[22] = "babaa";
  balphabet[23] = "babab";
  balphabet[24] = "babba";
  balphabet[25] = "babbb";
}

int baconian::execute_option(char option){
  int valid = TRUE;

  switch(option){
    case SUBSTITUTE:
      substitute();
      break; 
    case UNDO:
      undo();
      break;
    case GROUPSUB:
      groupsub();
      break;
    case LOCATE:
      locate_tip();
      break;
    default:
      valid = base_exec_option(option);
      break;
  }

  return valid;
}

int baconian::set_period(int newperiod){
  period = 5;
  return TRUE;
}

void baconian::locate_tip(){
  char temp_str[STRINGLENGTH], tip[STRINGLENGTH];
  Key tkey;
  char *c;
  int startpos, i, j, valid = TRUE;

  key.duplicate(&tkey);

  /* Get the start position from the user
  */

  prompt("At which group would you like to start the search? ");
  read_line(temp_str);

  if(strlen(temp_str) != 5 && *temp_str){
    msgerror("Group must have a length of 5.");
    valid = FALSE;
  }
  else if( (c = strstr(cipher, temp_str)) == NULL ||
	    (c - cipher)%5 != 0){
    msgerror("Group %s does not exist.", temp_str);
    valid = FALSE;
  }
  /* Now get the tip
  */
  else{
    startpos = (int) (c - cipher);

    prompt("What is the tip? ");
    read_line(temp_str);
    strcpy(tip, temp_str);

    if(strlen(tip) > length - startpos){
      msgerror("Tip too long for that starting position.");
      valid = FALSE;
    }
    else{
      /* Ok, we have a valid tip.  Try to match it to every position
      ** until we find one that works.  Start off with valid being FALSE
      ** so that the loop doesn't terminate right away.
      */
      valid = BAD_SUB;
      for(i = startpos; i + strlen(tip) < length && valid != NEW_SUB; i+= 5){
	valid = NEW_SUB;
	tkey.duplicate(&key);
	for(j = 0; tip[j] && valid == NEW_SUB; j++){
	  strncpy(temp_str, cipher+i+j*5, 5);
	  temp_str[5] = (char) NULL;
	  valid = sub_string(tip[j], temp_str);
	}
      }
      if(valid != NEW_SUB){
	key.duplicate(&key);
      }
    }
  }
}

void baconian::substitute(){
  char letter, bletter;

  prompt("What is the ct letter? ");
  letter = get_char();
  if(!isalpha(letter))
    msgerror("Value must be a letter.");
  else{
    prompt("What is the baconian value (a or b)? ");
    bletter = get_char();
    if(bletter != 'a' && bletter != 'b'){
      msgerror("Value must be either 'a' or 'b'.");
    }
    else{
      /* Is this a valid substitution?
      */
      if(!is_valid_sub(bletter, letter)){
        msgerror("Bad substitution.  Can't have two b's in a row.");
      }
      else if(key.alter(bletter, key.index(letter)) == BAD_SUB){
	msgerror("Bad substitution.");
      }
    }
  }
}

int baconian::is_valid_sub(char flag, char letter){
  int i, valid = TRUE;

  for(i = 0; i < length; i+= 5){
    if(( (cipher[i] == letter && flag == BFLAG) || 
	  key.val(cipher[i]) == BFLAG) && 
	 ((cipher[i+1] == letter  && flag == BFLAG) || 
	  key.val(cipher[i+1]) == BFLAG) ){
      valid = FALSE;
    }
  }

  return valid;
}

void baconian::groupsub(){
  int valid = TRUE;
  char tmp_str[STRINGLENGTH];
  char *c, letter;
  Key tkey;

  key.duplicate(&tkey);

  prompt("What is the group? ");
  read_line(tmp_str);
  if(strlen(tmp_str) != 5){
    msgerror("Group must be 5 characters long.");
    valid = FALSE;
  }
  else if(strstr(cipher, tmp_str) == NULL){
    msgerror("Group does not appear in cipher.");
    valid = FALSE;
  }
  else{
    c = strstr(cipher, tmp_str);
    if( (c - cipher)%5 != 0){
      msgerror("Bad group position.");
      valid = FALSE;
    }
    else{
      prompt("What letter does this group represent? ");
      letter = get_char();
      if(!isalpha(letter)){
	msgerror("Letter must be a letter from a to z.");
	valid = FALSE;
      }
      else{
	valid = sub_string(letter|' ', tmp_str);
	if(valid == FALSE){
	  msgerror("Bad substitution.");
	  tkey.duplicate(&key);
	}
      }
    }
  }
}

void baconian::undo(){
  char letter;

  prompt("Which letter would you like to undo? ");
  letter = get_char();
  if('*' == letter){
    key.clearkey();
  }
  else{
    key.clearkey(letter);
  }
}

void baconian::show_menu(){
  menu(1, "Options: (S)ubstite  (G)roup sub  (L)ocate tip  (U)ndo  (W)rite  (Q)uit");
}

void baconian::show_key(){
  int i;

  /* Show the baconian substitutes that the user
  ** has already made.
  */

  for(i = 0; i < 26; i++){
    put_char(key.val(i), i*3, 0);
    put_char(toupper(i+ 'a'), i*3, 1);
    msgprint(33, 2, "Baconian Key");
  }

  /* For kicks (and helpfulness), show the entire baconian alphabet.
  */

  for(i = 0; i < 13; i++){
    msgprint(i*6,   3, balphabet[i]);
    put_char(i + 'A', i*6+2, 4);
    msgprint(i*6,   6, balphabet[i+13]);
    put_char(i +13 + 'A', i*6+2, 7);
  }
  msgprint(31, 8, "Baconian Alphabet");
}

void baconian::show_cipher(){
  int i, line_length, period = 5;
  char tmp_str[20];

  line_length = 80 / (period+1);
  i = 0;
  while(i < length){

    /* First put the ciphertext on a line
    */

    strncpy(tmp_str, cipher+i, period);
    tmp_str[period] = (char) NULL;
    msgprint((i*(period+1)/period)%(line_length*(period+1)), (i/(line_length*period))*3 + 11, tmp_str);

    /* Now put the baconian a/b units above the ciphertext
    */

    stringtob(tmp_str);
    msgprint((i*(period+1)/period)%(line_length*(period+1)), (i/(line_length*period))*3 + 10, tmp_str);

    /* Now decode the baconian string into the corresponding letter.
    */

    bstringtochar(tmp_str);
    msgprint((i*(period+1)/period)%(line_length*(period+1)), (i/(line_length*period))*3 + 9, tmp_str);

    i += period; 
  }
}
  
int baconian::sub_string(char letter, char group[6]){
  int i, valid = TRUE;
  int status = NEW_SUB;
  char btext[6];

  bconv(letter, btext);

  for(i = 0; i < strlen(group) && status == NEW_SUB; i++){
    valid = is_valid_sub(btext[i], group[i]);
    if(valid != TRUE)  	 status = BAD_SUB;
    else		 status = key.alter(btext[i], key.index(group[i]));
  }
  
  return status;
}

void baconian::bconv(char letter, char btext[6]){
  strcpy(btext, balphabet[letter - 'a']);
}

void baconian::stringtob(char *string){
  while(*string){
    *string = key.val(*string);
    string++;
  }
}

void baconian::bstringtochar(char *string){
  int i, letter_inserted = FALSE;

  /* convert the 5 letter string to it's baconian equivalent (if it
  ** exists).  Put the letter in the middle of the string, surrounded by
  ** spaces.  If the letter is v/w or i/j, write it as "v/w", "i/j".
  */

  for(i = 0; i < 26; i++){
    if(strcmp(balphabet[i], string) == 0){
      if(i == 8 || i == 9){
	strcpy(string, " I/J ");
      }
      else if(i == 20 || i == 21){
	strcpy(string, " U/V ");
      }
      else{
	sprintf(string, "  %c  ", toupper(i+'a'));
      }
      letter_inserted = TRUE;
    }
  }

  if(!letter_inserted)
    strcpy(string, "     ");
}

void baconian::decipher(char *string){
  char temp_str[STRINGLENGTH];
  int i;

  for(i = 0; i < length; i+=period){
    strncpy(temp_str, cipher+i, 5);
    temp_str[5] = (char) NULL;

    stringtob(temp_str);
    bstringtochar(temp_str);
    *string++ = temp_str[2];
  }
  *string = (char) NULL;
}
