// -------- quiksort.h
#ifndef QUIKSORT_H
#define QUIKSORT_H

// ---- template function for quicksort algorithm

template<class T>
void swap(T& t1, T& t2)
{
    T hold = t2;
    t2 = t1;
    t1 = hold;
}

template<class T>
void quicksort(T array[], int n)
{
    if (n > 1)    {
        int j = n;
        // --- approximate median key
        T medKey = array[j/2];
        // --- swap the median key with the first
        swap(array[j/2], array[0]);
        //  sort everything higher than median above it
        //  and everything lower below it
        for (int i = 0; i < j; )    {
            while (array[++i] < medKey && i < j-1)
                ;
            while (array[--j] > medKey)
                ;
            if (i < j)
                swap(array[j], array[i]);
        }
        array[0] = array[j];
        array[j] = medKey;
        // --- sort the bottom set
        quicksort(array, j);
        // --- sort the top set
        quicksort(array+j+1, n-j-1);
    }
}

#endif

