// ex08012.cpp
// Overloaded -> operator
#include <iostream.h>

class Date {
    int mo, da, yr;
public:
    Date(int m=0, int d=0, int y=0)
		{ mo = m; da = d; yr = y; }
    void display() 
        { cout << '\n' << mo << '/' << da << '/' << yr; }
};
// ----------- "smart" Date pointer
class DatePtr {
    Date *dp;
public:
    DatePtr(Date *d = 0) { dp = d; }
    Date *operator->();
};

Date *DatePtr::operator->()
{
    static Date nulldate(0,0,0);
    if (dp == 0)           // if the pointer is NULL
        return &nulldate;  // return the dummy address
    return dp;             // otherwise return the pointer
}

main()
{
    DatePtr dp;       // date pointer with nothing in it
    dp->display();    // use it to call display function
    Date dt(3,17,90); // Date
    dp = &dt;         // put address of date in pointer
    dp->display();    // display date through the pointer
}



