// ex07019.cpp
// The this pointer
#include <iostream.h>
#include <string.h>

// ------- date class
class Date {
    int mo, da, yr;
    char *month;
public:
    Date();
    Date(int m, int d, int y);
    ~Date();
    Date& operator=(Date&); //overloaded assignment operator
    void display();
};
// constructor that is called for an uninitialized Date
Date::Date()
{
    mo = 0; da = 0; yr = 0;
    month = 0;    
}
// constructor that is called for an initialized Date
Date::Date(int m, int d, int y)
{
    static char *mos[] = {
        "January", "February", "March", "April", "May", 
        "June", "July", "August", "September", "October", 
        "November", "December"
    };
    mo = m; da = d; yr = y;
    month = new char[strlen(mos[m-1])+1];
    strcpy(month, mos[m-1]);
}

// Destructor for a Date
Date::~Date()
{
    delete month;
}

// ----------- display member function
void Date::display() 
{
    if (month != 0)
        cout << '\n' << month << ' ' << da << ", " 
             << yr+1900;
}

// ---------- overloaded Date assignment
Date& Date::operator=(Date& dt)
{
    mo = dt.mo;
    da = dt.da;
    yr = dt.yr;
    delete month;
    if (dt.month != 0)    {
        month = new char [strlen(dt.month)+1];
        strcpy(month, dt.month);
    }
    else
        month = 0;
    return *this;
}

main()
{
    // ------ original date
    Date birthday(6,24,40);
    Date oldday, newday;
    // ------ assign first to second to third
    oldday = newday = birthday;
    birthday.display();
    oldday.display();
    newday.display();
}

