// ex07014.cpp
// Friend classes, forward reference
#include <iostream.h>

// -------- Julian date class
class Julian {
    int da, yr;
public:
    Julian() {}
    Julian(int d, int y) { da = d; yr = y;}
    void display() {cout << '\n' << yr << '-' << da;}
    friend class Date;    // <--- forward reference to class
};

// ------- date class
class Date {
    int mo, da, yr;
public:
    Date(int m, int d, int y) { mo = m; da = d; yr = y; }
    operator Julian();
};

static int dys[] = {31,28,31,30,31,30,31,31,30,31,30,31};

// ---- member conversion function (Julian <- Date)
Date::operator Julian()
{
    Julian jd(0, yr);
    for (int i = 0; i < mo-1; i++)
        jd.da += dys[i];
    jd.da += da;
    return jd;
}

main()
{
    Date dt(11,17,89);
    Julian jd;
    jd = dt;
    jd.display();
}

