// ex07007.cpp
// Converting classes
#include <iostream.h>

// -------- Julian date class
class Julian {
public:
    int da, yr;
    Julian() {}
    Julian(int d, int y) { da = d; yr = y;}
    void display(){ cout << '\n' << yr << '-' << da; }
};

// ------- date class
class Date {
    int mo, da, yr;
public:
    Date() {}
    Date(int m, int d, int y) { mo = m; da = d; yr = y; }
    Date(Julian);         // constructor conversion function
    operator Julian();    // member conversion function
    void display(){cout << '\n' << mo << '/' << da 
                        << '/' << yr;}
};

static int dys[] = {31,28,31,30,31,30,31,31,30,31,30,31};

// ---- constructor conversion function (Date <- Julian)
Date::Date(Julian jd)
{
    yr = jd.yr;
    da = jd.da;
    for (mo = 0; mo < 11; mo++)
        if (da > dys[mo])
            da -= dys[mo];
        else
            break;
    mo++;
}


// ---- member conversion function (Julian <- Date)
Date::operator Julian()
{
    Julian jd(0, yr);
    for (int i = 0; i < mo-1; i++)
        jd.da += dys[i];
    jd.da += da;
    return jd;
}

main()
{
    Date dt(11,17,89);
    Julian jd;
    // ------- convert Date to Julian
    jd = dt;
    jd.display();
    // ------- convert Julian to Date
    dt = jd;
    dt.display();
}

